<?php

namespace App\Console\Commands;
use Illuminate\Support\Facades\File;
use Illuminate\Console\Command;

use App\Notifications\ScheduleErrorNotification;

class Backup extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'backup:run';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        // manual taking database backup
        try{
            $dbname = config('database.connections.mysql.database');
            $path = storage_path('app/backups/'.config('app.name').'/');
            if(!File::exists($path)){
                File::makeDirectory($path, 0755, true, true);
            }
            $filename = $path.'Database-'.date('Y-m-d-h-i-s').'.sql';
            exec("mysqldump \"--user=".config('database.connections.mysql.username')."\" \"--password=".config('database.connections.mysql.password')."\" ".config('database.connections.mysql.database')." > ".$filename);
        } catch (Exception $e) {
            $output = array('Exception' => 'File:' .$e->getFile(). 'Line:' .$e->getLine(). 'message' .$e->getMessage(),'type' => 'error');
            Notification::route('mail', env('DB_BACKUP_EMAIL'))->notify(new  ScheduleErrorNotification($output));
        }
    }
}
