<?php

namespace App\Http\Controllers\App\V1;
use App\Models\User;
use App\Models\Page;
use App\Models\Setting;
use Illuminate\Support\Facades\Collection;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Notification;
use App\Notifications\ContactUsNotification;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;
use Carbon\Carbon;
class IndexController extends Controller
{
    public function contactUs(Request $request)
    {
        $data = $this->validate($request, [
            'name'          =>  ['required','string','max:50','regex:/^[a-zA-Z0-9 ]*$/'],
            'email'         =>  'required|string|email|max:50',
            'phone'         =>  'required|numeric',
            'subject'       =>  'required|string|max:255',
            'message'       =>  'required|string',
        ]);
        $data = array('greeting' => 'Hi '.config('app.name'),'name' => $data['name'], 'email' => $data['email'],'phone' => $data['phone'], 'subject' => $data['subject'], 'message' => $data['message'], 'info' => request()->get('settings')[4]->value);
        try {
            Notification::route('mail', 'ammalnaveed50@gmail.com')->notify(new ContactUsNotification($data));
            return  response()->json([
                'message' => 'Thank you for contacting us will get back you soon.','status' => 'success'
            ],200);
        } catch (\Exception $e) {
            return  response()->json([
            'message' => $e->getMessage(),'status'=>'danger'
        ],200);
        }
        return  response()->json([
            'message' => 'Thank you for writing us. We will get back you soon!','status'=>'success'
        ],200);
    }
    
    public function pages(Request $request){
        $pages = Page::whereStatus('Active')->select('id','title','description','slug')->get();
         return  response()->json([
            'data' => $pages
        ],200);
    }
    public function settings(Request $request)
    {
        $settings = Setting::select('id','name','value')->get();
        return response()->json([
            'data'  =>  $settings,
        ],200);
    }
    public function countries(Request $request)
    {
        $countries = Country::get();
        return response()->json([
            'data'  =>    $countries,
        ],200);
    }
}
