<?php

namespace App\Http\Controllers\Web;
use App\Models\Room;
use App\Models\Offer;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class IndexController extends Controller
{
    public function sitemap(Request $request)
    {
        $rooms = Room::whereStatus('Active')->get();
        $offers = Offer::whereStatus('Active')->whereDate('valid_untill','>=',date('Y-m-d'))->get();
        return response()->view('sitemap', [
            'rooms'         =>  $rooms,
            'offers'        =>  $offers,
        ])->header('Content-Type', 'text/xml');
    }
}
