<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class EnsureTwoFactorEnabled
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        if ($request->user() && $request->user()->two_factor_secret && $request->user()->two_factor_confirmed_at) {
            if (!$request->session()->get('2fa_verified')) {
                return redirect()->route('two-factor.verify');
            }
        }
        return $next($request);
    }
}
