<?php

namespace App\Http\Middleware;
use App\Models\Language;
use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Session;
use Symfony\Component\HttpFoundation\Response;


class SetLocale
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        
        $locale = Session::get('locale');
        if (session()->has('locale')) {
            App::setLocale(session()->get('locale'));
        }
        if (!$locale) {
            $defaultLanguage = Language::where('is_default', 'Yes')->first();
            $locale = $defaultLanguage->locale ?? config('app.locale');
            Session::put('locale', $locale);
            Session::put('direction', $defaultLanguage->direction);
            Session::put('language_id', $defaultLanguage->id);
        }
        App::setLocale($locale);
        
        return $next($request);
    }
}
