<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use Illuminate\Support\Facades\Log;

class VerifyHmacSignature
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $payload = $request->header('X-App-Payload');
        $signature = $request->header('X-App-Signature');

        if (!$payload || !$signature) {
            return response()->json(['message' => 'Unauthorized. Missing signature.'], 401);
        }

        $secret = base64_decode(env('MOBILE_APP_KEY'));

        $expectedSignature = hash_hmac('sha256', $payload, $secret);

        if (!hash_equals($expectedSignature, $signature)) {
            return response()->json(['message' => 'Invalid signature.'], 403);
        }

        // Optional: Prevent replay attacks using timestamp
        $parts = explode('|', $payload);
        $timestamp = $parts[1] ?? null;

        if (!$timestamp || now()->diffInSeconds($timestamp) > 120) {
            return response()->json(['message' => 'Signature expired.'], 403);
        }
        return $next($request);
    }
}
