<?php

namespace App\Livewire\Admin;

use Livewire\Component;
use Livewire\WithPagination;

use App\Models\User;
use App\Models\ActivityLog;
use App\Livewire\Traits\AuthorizesRequests;

use Illuminate\Support\Facades\Gate;

class ActivityLogComponent extends Component
{
    use WithPagination,AuthorizesRequests;
    public $search = '';
    public $user, $method, $start, $end;
    public $perPage = 10;
    protected $listeners = ['updateChoices'];
    
    public function updateChoices($property, $value)
    {
        $this->$property = $value;
    }

    public function render()
    {
        if (!Gate::allows('view_activitylog') && !Gate::allows('view_all')) {
            return $this->authorizeAndRedirect();
		}
        $this->dispatch('select2');
        $query = ActivityLog::query();
        if($this->search){
            $query->where('path', 'like', '%' .$this->search. '%')
            ->orWhere('model_type', 'like', '%' .$this->search. '%')
            ->orWhere('method', 'like', '%' .$this->search. '%')
            ->orWhere('ip', 'like', '%' . $this->search. '%')
            ->orWhere('old_values', 'like', '%' .$this->search. '%')
            ->orWhere('new_values', 'like', '%' .$this->search. '%')
            ->orWhere('created_at', 'like', '%' .$this->search. '%')
            ->orWhere('updated_at', 'like', '%' .$this->search. '%');
        }
        if($this->method){
            $query->whereMethod($this->method);
        }
        if($this->user){
            $query->whereUserId($this->user);
        }
        
        if ($this->start && $this->end) {
                $query->whereDate('created_at', '>=', $this->start)->whereDate('created_at', '<=', $this->end);
        }
        if ($this->start && !$this->end) {
            $query->whereDate('created_at', '>=', $this->start);
        }
        if (!$this->start && $this->end) {
                $query->whereDate('created_at', '<=', $this->end);
        }

        $collection = $query->orderBy('id','DESC')->paginate($this->perPage);
        $users = User::select('id','name')->get()->toArray();
        $methods = [
            ['id' => 'GET', 'name' => 'GET'],
            ['id' => 'POST', 'name' => 'POST'],
            ['id' => 'PUT', 'name' => 'PUT'],
            ['id' => 'DELETE', 'name' => 'DELETE'],
            ['id' => 'OPTIONS', 'name' => 'OPTIONS'],
            ['id' => 'HEAD', 'name' => 'HEAD'],
            ['id' => 'UNLINK', 'name' => 'UNLINK'],
            ['id' => 'COPY', 'name' => 'COPY'],
            ['id' => 'PURGE', 'name' => 'PURGE']
        ];
        return view('admin.activity-log-component',compact('collection','users','methods'));
    }

    public function delete($ids)
    {
        if (!Gate::allows('delete_activitylog') && !Gate::allows('delete_all')) {
            return $this->authorizeAndRedirect();
        }
        $collection = ActivityLog::find($ids);
        if($collection->count()){
            foreach($collection as $item){
                $item->delete();
            }
        } 
        $this->dispatch('response', ['type' => 'success', 'message' => 'Activity Log Login History has been deleted successfully!']);
        $this->dispatch('hideModal',['modal'=>'confirmModal']);
    }
}
