<?php

namespace App\Livewire\Admin;

use Livewire\Component;

class ChoicesComponent extends Component
{
    public $options = [];
    public $selected = null;  // Selected value(s)
    public $multiple = false;
    public $model = '';

    public function mount($options = [], $selected = null, $multiple = false, $model = '')
    {
        $this->options = $options;
        $this->selected = $selected;
        $this->multiple = $multiple;
        $this->model = $model;
        $this->updatedSelected();
    }
    public function updatedSelected()
    {
        if ($this->model) {
            $this->dispatch('updateChoices', $this->model, $this->selected);
        }
    }

    public function render()
    {
        return view('admin.choices-component');
    }
}


