<?php

namespace App\Livewire\Admin;

use Livewire\Component;
use Livewire\WithPagination;
use App\Livewire\Traits\AuthorizesRequests;

use App\Models\User;
use App\Models\UserLoginHistory;
use Illuminate\Support\Facades\Hash;
use Illuminate\Validation\Rule;
use Illuminate\Support\Facades\Gate;



class LoginHistoryComponent extends Component
{
    use WithPagination, AuthorizesRequests;
    public $search = '';
    public $user; 
    public $perPage = 10;
    
    protected $listeners = ['updateSelect2'];
    
    public function updateSelect2($ids = null)
    {
        $this->user = $ids;
    }
    public function render()
    {
        if (!Gate::allows('view_user') && !Gate::allows('view_all')) {
            return $this->authorizeAndRedirect();
        }
        $this->dispatch('select2');
        $query = UserLoginHistory::with('user');
        if($this->search){
            $query->where('city', 'like', '%' . $this->search. '%')
            ->orWhere('country', 'like', '%' . $this->search. '%')
            ->orWhere('country_code', 'like', '%' . $this->search. '%')
            ->orWhere('region', 'like', '%' . $this->search. '%')
            ->orWhere('region_code', 'like', '%' . $this->search. '%')
            ->orWhere('timezone', 'like', '%' . $this->search. '%')
            ->orWhere('postal_code', 'like', '%' . $this->search. '%')
            ->orWhere('latitude', 'like', '%' . $this->search. '%')
            ->orWhere('longitude', 'like', '%' . $this->search. '%')
            ->orWhere('ip', 'like', '%' . $this->search. '%')
            ->orWhere('device', 'like', '%' . $this->search. '%');
        }
        if($this->user){
            $query->whereUserId($this->user)->where('notifiable_type','App\Models\User');
        }
        $collection = $query->orderBy('id','DESC')->paginate($this->perPage);
        $users = User::select('id','name')->get();
        return view('admin.login-history-component',compact('collection','users'));
    }
    public function delete($ids)
    {
        if (!Gate::allows('delete_loginhistory') && !Gate::allows('delete_all')) {
            return $this->authorizeAndRedirect();
        }
        $collection = UserLoginHistory::find($ids);
        if($collection->count()){
            foreach($collection as $item){
                $item->delete();
            }
        } 
        $this->dispatch('response', ['type' => 'success', 'message' => 'User Login History has been deleted successfully!']);
        $this->dispatch('hideModal',['modal'=>'confirmModal']);
    }

}
