<?php

namespace App\Livewire\Admin;

use App\Models\Setting;
use App\Helpers\Helper;
use App\Livewire\Traits\AuthorizesRequests;

use Illuminate\Support\Facades\Gate;

use Livewire\Component;

class SocialSettingsComponent extends Component
{
    use AuthorizesRequests;
    public 
    $login_with_email,
    $login_with_phone,
    $login_with_username,

    $google_login, 
    $google_app_id, 
    $google_secret_id, 
    $google_callback_url, 

    $facebook_login, 
    $facebook_app_id, 
    $facebook_secret_id, 
    $facebook_callback_url, 

    $apple_login, 
    $apple_app_id, 
    $apple_secret_id, 
    $apple_callback_url, 

    $facebook_url, 
    $instagram_url, 
    $linkedin_url, 
    $twitter_url, 
    $tiktok_url,
    $youtube_url,
    $snapchat_url;

    public function mount(){
        $settings = Setting::select('id','name','value')->get();
        $this->login_with_email     = $settings[18]->value;
        $this->login_with_phone     = $settings[19]->value;
        $this->login_with_username  = $settings[20]->value;

        $this->google_login         = $settings[21]->value; 
        $this->google_app_id        = $settings[22]->value;
        $this->google_secret_id     = $settings[23]->value;
        $this->google_callback_url  = $settings[24]->value;

        $this->facebook_login       = $settings[25]->value;
        $this->facebook_app_id      = $settings[26]->value;
        $this->facebook_secret_id   = $settings[27]->value;
        $this->facebook_callback_url= $settings[28]->value;

        $this->apple_login          = $settings[29]->value;
        $this->apple_app_id         = $settings[30]->value; 
        $this->apple_secret_id      = $settings[31]->value;
        $this->apple_callback_url   = $settings[32]->value;

        $this->facebook_url         = $settings[33]->value;
        $this->instagram_url        = $settings[34]->value;
        $this->linkedin_url         = $settings[35]->value;
        $this->twitter_url          = $settings[36]->value; 
        $this->tiktok_url           = $settings[37]->value;
        $this->youtube_url          = $settings[38]->value;
        $this->snapchat_url         = $settings[39]->value;
    }
    public function render()
    {
        if (!Gate::allows('view_socialsettings') && !Gate::allows('view_all')) {
			return $this->authorizeAndRedirect();
		}
        return view('admin.settings.social-settings-component');
    }
    public function updateSocialSettings(){
		if (!Gate::allows('view_socialsettings') && !Gate::allows('view_all')) {
			return $this->authorizeAndRedirect();
		}
        $data = $this->validate([
            'login_with_phone'   =>  'required|numeric|in:0,1',
            'login_with_email'   =>  'required|numeric|in:0,1',
            'login_with_username'=>  'required|numeric|in:0,1',

            'google_login'           =>  'required|numeric|in:0,1',
            'google_app_id'          =>  'nullable|max:255',
            'google_secret_id'       =>  'nullable|max:255',
            'google_callback_url'    =>  'nullable|max:255',

            'facebook_login'         =>  'required|numeric|in:0,1',
            'facebook_app_id'        =>  'nullable|max:255',
            'facebook_secret_id'     =>  'nullable|max:255',
            'facebook_callback_url'  =>  'nullable|max:255',

            'apple_login'            =>  'required|numeric|in:0,1',
            'apple_app_id'           =>  'nullable|max:255',
            'apple_secret_id'        =>  'nullable|max:255',
            'apple_callback_url'     =>  'nullable|max:255',
          ]);
          foreach($data as $key => $value){
            $checkExist = Setting::whereName($key)->first();
			if($checkExist){
				$checkExist->update(['value'=>addslashes($value)]);
			}
          }
        return $this->dispatch('response', ['type' => 'success', 'message' => 'Social settings has been updated successfully!']);
	}
    public function updateSocialLinks(){
		if (!Gate::allows('view_socialsettings') && !Gate::allows('view_all')) {
			return $this->authorizeAndRedirect();
		}
        $data = $this->validate([
          	'facebook_url'        	=>  'string|max:255',
            'instagram_url'         =>  'string|max:255',
            'linkedin_url'     		=>  'string|max:255',
            'twitter_url'  			=>  'string|max:255',
			'tiktok_url' 			=>  'string|max:255',
            'youtube_url' 			=>  'string|max:255',
            'snapchat_url' 			=>  'string|max:255',
        ]);
        foreach($data as $key => $value){
            $checkExist = Setting::whereName($key)->first();
			if($checkExist){
				$checkExist->update(['value'=>addslashes($value)]);
			}
        }
        return $this->dispatch('response', ['type' => 'success', 'message' => 'Social Links has been updated successfully!']);
	}
}
