<?php

namespace App\Livewire\Web;

use Illuminate\Support\Facades\Notification;
use App\Notifications\ContactUsNotification;
use Livewire\Component;

class ContactComponent extends Component
{
    public $name,$email,$subject,$message;
    public function contact(){
        $data = $this->validate([
            'name'          =>  'required|string|max:50',
            'email'         =>  'required|string|email|max:100',
            'subject'       =>  'required|string|max:150',
            'message'       =>  'required|string'
        ]);
        $data = array(
            'greeting' => 'Dear Imperial Suites',
            'name' => $data['name'],
            'email' => $data['email'],
            'subject' => $data['subject'],
            'message' => $data['message'], 
            'info' => request()->get('settings')[4]->value
        );
        Notification::route('mail', $data['info'])->notify(new ContactUsNotification($data));
        $this->dispatch('response', ['type' => 'success', 'message' => __('web.Thank you for reaching us. We will get back you soon.')]);
    }
    public function render()
    {
        return view('web.pages.contact')->layout('web.layouts.app');
    }
}