<?php
namespace App\Livewire\Web;

use Livewire\Component;
use App\Models\Feedback;
use Illuminate\Support\Facades\Validator;
class FeedbackForm extends Component
{
    public $rating, $subject, $message;

    public $createModal = false;
    protected $listeners = ['createModal'];
    public function createModal(){
        $this->createModal = false;
    }
    public function create()
    {
        $this->pull();
        $this->resetErrorBag();
        $this->createModal = true;
        $this->dispatch('showModal',['modal'=>'createModal']);
    }
    public function feedback()
    {
       
        $data = $this->validate([
            'rating'        =>  'required|numeric',
            'subject'       =>  'required|in:all_good,enhancement,tech_issue,loading_time',
            'message'       =>  'required|alpha_spaces|max:150',
        ]);
        $data['page'] = url()->current();
        Feedback::create($data);
        $this->reset();
        $this->dispatch('hideModal', ['modal' => 'createModal']);
        $this->dispatch('response', ['type' => 'success', 'message' => __('web.Thank you for your feedback!')]);
    }
    public function render()
    {
        return view('web.feedback-form');
    }
}
