<?php

namespace App\Livewire\Web;

use App\Models\Language;
use Livewire\Component;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Str;
use DB;
class LanguageSwitcher extends Component
{
    public $languages;

    public function mount()
    {
        $this->languages = Language::where('status', 'Active')->get();
        $this->currentLocale = session('locale', app()->getLocale());
    }

    public function switchLanguage($locale)
    {
        
        $lang = Language::where('locale', $locale)->first();
        if ($lang) {
            Session::put('locale', $lang->locale);
            Session::put('direction', $lang->direction);
            Session::put('language_id', $lang->id);
            App::setLocale($lang->locale);
        }
        return redirect()->to(url()->previous());
    }

    public function render()
    {
        return view('web.language-switcher');
    }
}
