<?php

namespace App\Livewire\Web;
use App\Models\Offer;
use App\Models\Service;
use Livewire\Component;

class OfferDetailComponent extends Component
{
    public $slug;
    public function render()
    {
        $offer = Offer::whereSlug($this->slug)->whereStatus('Active')->whereDate('valid_untill','>=',date('Y-m-d'))->first();
        if($offer){
            $pageTitle = $offer->translation()->name;
            return view('web.offer',compact('pageTitle','offer'))->layout('web.layouts.app');
        }else{
            return $this->redirect('/offers',navigate:true);
        }
    }
}