<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class ActivityLog extends Model
{
    use HasFactory, SoftDeletes;
    protected $table = 'activity_logs';
    protected $fillable = [
        'user_id',
        'model_type',
        'model_id',
        'action',
        'path',
        'method',
        'ip',
        'old_values',
        'new_values',
    ];
    protected $casts = [
        'old_values' => 'array',
        'new_values'=> 'array',
    ];
    protected static function booted()
    {
        static::deleting(function ($model) {
        });
    }
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class)->withDefault();
    }
}
