<?php

namespace App\Models;
use App\Traits\LogsActivity;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Module extends Model
{
    use HasFactory, SoftDeletes, LogsActivity;
    protected $table = 'modules';
    protected $fillable = ['name'];
    
    protected static function booted()
    {
        static::deleting(function ($model) {
            foreach($model->permissions as $permission){
                $permission->delete();
            }
        });
    }
    public function permissions(): HasMany
    {
        return $this->hasMany(Permission::class);
    }
}
