<?php

namespace App\Models;

use App\Traits\LogsActivity;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class OfferTranslation extends Model
{
    use HasFactory, SoftDeletes, LogsActivity;
    protected $table = 'offer_translations';
    protected $fillable = ['offer_id','language_id','title','short_description','description'];
    
    protected static function booted()
    {
        static::deleting(function ($model) {
        });
    }
    
    public function offer(): BelongsTo
    {
        return $this->belongsTo(Offer::class);
    }

    public function language(): BelongsTo
    {
        return $this->belongsTo(Language::class);
    }
}