<?php

namespace App\Models;

use App\Traits\LogsActivity;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Place extends Model
{
    use HasFactory, SoftDeletes, LogsActivity;
    protected $table = 'places';
    protected $fillable = ['image','url'];
    protected static function booted()
    {
        static::deleting(function ($model) {
            if ($model->translations->count()) {
                $model->translations->each->delete();
            }
        });
    }
    public function translations(): HasMany
    {
        return $this->hasMany(PlaceTranslation::class);
    }

    public function translation($language_id = null)
    {
        $language_id = $language_id ?? session('language_id');
        return $this->translations()->where('language_id', $language_id)->first();
    }
}