<?php

namespace App\Models;

use App\Traits\LogsActivity;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class PlaceTranslation extends Model
{
    use HasFactory, SoftDeletes, LogsActivity;
    protected $table = 'place_translations';
    protected $fillable = ['place_id', 'language_id', 'name', 'description'];
    
    protected static function booted()
    {
        static::deleting(function ($model) {
        });
    }
    
    public function place(): BelongsTo
    {
        return $this->belongsTo(Place::class);
    }

    public function language(): BelongsTo
    {
        return $this->belongsTo(Language::class);
    }
}