<?php
namespace App\Models;

use App\Traits\LogsActivity;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class PrivilegeTranslation extends Model
{
    use HasFactory, SoftDeletes, LogsActivity;
    protected $table = 'privilege_translations';
    protected $fillable = [
        'language_id',
        'privilege_id',
        'name',
    ];

    public function privilege(): BelongsTo
    {
        return $this->belongsTo(Privilege::class, 'privilege_id');
    }
}
