<?php

namespace App\Models;

use App\Traits\LogsActivity;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;


class Room extends Model
{
    use HasFactory, SoftDeletes, LogsActivity;
    protected $table = 'rooms';
    protected $fillable = [	
        'space',
        'price',	
        'status',	
        'slug',
    ];
    protected static function booted()
    {
        static::deleting(function ($model) {
            $model->translations()->delete();
            $model->photos()->delete();
            $model->facilities()->detach();
            $model->services()->detach();
            $model->privileges()->detach();
        });
    }
    public function photos(): HasMany 
    {
        return $this->hasMany(RoomPhoto::class);
    }
    public function translations(): HasMany
    {
        return $this->hasMany(RoomTranslation::class);
    }

    public function translation($language_id = null)
    {
        $language_id = $language_id ?? session('language_id');
        return $this->translations()->where('language_id', $language_id)->first();
    }
    public function facilities(): BelongsToMany
    {
        return $this->belongsToMany(Facility::class, 'room_facility', 'room_id', 'facility_id');
    }
    public function services(): BelongsToMany
    {
        return $this->belongsToMany(Service::class, 'room_service', 'room_id', 'service_id');
    }
    public function privileges(): BelongsToMany
    {
        return $this->belongsToMany(Privilege::class, 'room_privilege', 'room_id', 'privilege_id');
    }
}
