<?php
namespace App\Models;

use App\Traits\LogsActivity;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;

class RoomFacility extends Model
{
    use HasFactory, LogsActivity;
    protected $table = 'room_facility';
    public $timestamps = false;

    protected $fillable = [
        'room_id',
        'facility_id',
    ];

    public function room(): BelongsToMany
    {
        return $this->belongsTo(Room::class);
    }

    public function facility(): BelongsToMany
    {
        return $this->belongsTo(RoomFacility::class, 'facility_id');
    }
}