<?php

namespace App\Models;

use App\Traits\LogsActivity;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class RoomPhoto extends Model
{
    use HasFactory, SoftDeletes, LogsActivity;
    protected $table = 'room_photos';
    protected $fillable = [	
        'photo',	
        'room_id',
    ];
    protected static function booted()
    {
        static::deleting(function ($model) {
        });
    }
    public function privileges(): BelongsTo
    {
        return $this->belongsTo(Room::class);
    }
}
