<?php
namespace App\Models;

use App\Traits\LogsActivity;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;

class RoomPrivilege extends Model
{
    use HasFactory, LogsActivity;
    protected $table = 'room_privilege';
    public $timestamps = false;

    protected $fillable = [
        'room_id',
        'privilege_id',
    ];

    public function room(): BelongsToMany
    {
        return $this->belongsTo(Room::class);
    }

    public function privilege(): BelongsToMany
    {
        return $this->belongsTo(RoomPrivilege::class, 'privilege_id');
    }
}