<?php
namespace App\Models;

use App\Traits\LogsActivity;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;

class RoomService extends Model
{
    use HasFactory, SoftDeletes, LogsActivity;
    protected $table = 'room_services';
    protected $fillable = [
        'code', // or whatever you have as unique identifier
    ];
    protected static function booted()
    {
        static::deleting(function ($model) {
            if ($model->translations->count()) {
                $model->translations->each->delete();
            }
        });
    }
    public function translations(): HasMany
    {
        return $this->hasMany(RoomServiceTranslation::class, 'room_service_id');
    }

    public function translation($language_id = null)
    {
        $language_id = $language_id ?? session('language_id');
        return $this->translations()->where('language_id', $language_id)->first();
    }

    public function rooms(): BelongsToMany
    {
        return $this->belongsToMany(Room::class, 'room_services', 'room_service_id', 'room_id');
    }
}