<?php
namespace App\Models;

use App\Traits\LogsActivity;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;

class RoomServicePivot extends Model
{
    use HasFactory, LogsActivity;
    protected $table = 'room_service';
    public $timestamps = false;

    protected $fillable = [
        'room_id',
        'room_service_id',
    ];

    public function room(): BelongsToMany
    {
        return $this->belongsTo(Room::class);
    }

    public function service(): BelongsToMany
    {
        return $this->belongsTo(RoomService::class, 'room_service_id');
    }
}