<?php
namespace App\Models;

use App\Traits\LogsActivity;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class RoomServiceTranslation extends Model
{
    use HasFactory, SoftDeletes, LogsActivity;
    protected $table = 'room_service_translations';
    protected $fillable = [
        'language_id',
        'room_service_id',
        'name',
    ];

    public function service(): BelongsTo
    {
        return $this->belongsTo(RoomService::class, 'room_service_id');
    }
}
