<?php

namespace App\Models;

use App\Traits\LogsActivity;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class RoomTranslation extends Model
{
    use HasFactory, SoftDeletes, LogsActivity;
    protected $table = 'room_translations';
    protected $fillable = ['language_id','room_id','name','short_description','description','capacity'];
    
    protected static function booted()
    {
        static::deleting(function ($model) {
        });
    }
    
    public function room(): BelongsTo
    {
        return $this->belongsTo(Room::class);
    }

    public function language(): BelongsTo
    {
        return $this->belongsTo(Language::class);
    }
}