<?php

namespace App\Models;

use App\Traits\LogsActivity;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Testimonial extends Model
{
    use HasFactory, SoftDeletes, LogsActivity;
    protected $table = 'testimonials';
    protected $fillable = [	 
        'image',
    ];
    protected static function booted()
    {
        static::deleting(function ($model) {
            if ($model->translations->count()) {
                $model->translations->each->delete();
            }
        });
    }
    public function translations(): HasMany
    {
        return $this->hasMany(TestimonialTranslation::class);
    }

    public function translation($language_id = null)
    {
        $language_id = $language_id ?? session('language_id');
        return $this->translations()->where('language_id', $language_id)->first();
    }
}
