<?php

namespace App\Traits;

use App\Models\ActivityLog;

trait LogsActivity
{
    public static function bootLogsActivity()
    {
        static::created(function ($model) {
            $model->logActivity('created', null, $model->attributesToArray());
        });
        static::updated(function ($model) {
            $model->logActivity('updated', $model->getOriginal(), $model->getChanges());
        });
        static::deleted(function ($model) {
            $model->logActivity('deleted', $model->getOriginal(), null);
        });
    }
    protected function logActivity($action, $oldValues = null, $newValues = null)
    {
        ActivityLog::create([
            'user_id'       =>  auth()->id(),
            'model_type'    =>  get_class($this),
            'model_id'      =>  $this->id,
            'action'        =>  $action,
            'path'          =>  request()->route() ? request()->route()->getName() : request()->path(),
            'method'        =>  request()->method(),
            'ip'            =>  request()->getClientIp(),    
            'old_values'    =>  $oldValues,
            'new_values'    =>  $newValues,
        ]);
    }
}
