<div>
    <section class="section register min-vh-100 d-flex flex-column align-items-center justify-content-center py-4">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-5 col-md-6 d-flex flex-column align-items-center justify-content-center">
                    <div class="d-flex justify-content-center py-4">
                        <a href="{{ route('login') }}" class="logo d-flex align-items-center w-auto">
                            <img src="{{ asset(Request::get('settings')[3]->value) }}" alt="..." />
                            <span class="d-none d-lg-block">Welcome To {{ Request::get('settings')[0]->value }}</span>
                        </a>
                    </div>
                    <!-- End Logo -->
                    <div class="card border border-light-subtle shadow-sm">
                        <div class="card-body p-5">
                            <div class="mb-4">
                                <div class="card-title text-center pb-0 fs-5">{{ __('Reset Password') }}</div>
                                <div class="small text-muted text-center">{{ __('Forgot your password? No problem. Just let us know your email address and we will email you a password reset link that will allow you to choose a new one.') }}</div>
                            </div>
                            <form wire:submit="sendResetLink" class="needs-validation" novalidate>
                                <div class="row row-cols-1 row-cols-lg-1 g-3 g-lg-3">
                                    <div class="col">
                                        <x-input-floating type="email" name="email" :messages="$errors->get('email')"/>
                                    </div>
                                    <div class="col">
                                        <button class="btn btn-primary w-100" type="submit" wire:loading.attr="disabled" wire:loading.class="opacity-50">
                                            <span wire:loading wire:target="sendResetLink" class="spinner-border spinner-border-sm me-2" aria-hidden="true"></span>
                                            {{ __('Send Password Reset Link') }}
                                        </button>
                                    </div>
                                    <div class="col text-center">
                                        <a href="{{ route('login') }}" wire:navigate class="align-middle">Back to login</a>
                                    </div>
                                    
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                <div class="text-center mt-3">Designed by <a href="https://www.smart-tech.com" target="_blank">Smart Tech</a></div>
            </div>
        </div>
    </section>
    <x-toast on="response"></x-toast>
</div>
