<div>
    <section class="section register min-vh-100 d-flex flex-column align-items-center justify-content-center py-4">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-5 col-md-6 d-flex flex-column align-items-center justify-content-center">
                    <div class="d-flex justify-content-center py-4">
                        <a href="{{ route('login') }}" class="logo d-flex align-items-center w-auto">
                            <img src="{{ asset(Request::get('settings')[3]->value) }}" alt="..." />
                            <span class="d-none d-lg-block">Welcome To {{ Request::get('settings')[0]->value }}</span>
                        </a>
                    </div>
                    <!-- End Logo -->
                    <div x-data="{ recovery: false }" class="card border border-light-subtle shadow-sm">
                        <div class="card-body p-5">
                            <div class="mb-3">
                                <div class="card-title text-center pb-0 fs-5">{{ __('Two Step Verification') }}</div>
                            </div>
                            <div  class="row row-cols-1 row-cols-lg-1 g-3 g-lg-3">
                                <div class="col">
                                    <div class="small text-muted" x-show="! recovery">{{ __('Please confirm access to your account by entering the authentication code provided by your authenticator application.') }}</div>
                                    <div class="small text-muted" x-cloak x-show="recovery" >{{ __('Please confirm access to your account by entering one of your emergency recovery codes.') }}</div>
                                </div>
                                <form wire:submit="verify2FACode" class="needs-validation" novalidate x-show="! recovery">
                                    <div class="col">
                                        <x-input-floating name="code" :messages="$errors->get('code')" x-ref="code"/>
                                    </div>
                                    <div class="col text-end mt-auto">
                                        <button type="button" class="btn btn-link" x-show="! recovery" x-on:click="recovery = true; $nextTick(() => { $refs.recovery_code.focus() }) ">{{ __('Use a recovery code') }}</button>
                                    </div>
                                    <div class="col">
                                        <button class="btn btn-primary w-100" type="submit" wire:loading.attr="disabled" wire:loading.class="opacity-50">
                                            <span wire:loading wire:target="verify2fa" class="spinner-border spinner-border-sm me-2" aria-hidden="true"></span>
                                            {{ __('Login') }}
                                        </button>
                                    </div>
                                </form>
                                <form wire:submit="verify2FARecoveryCode" class="needs-validation" novalidate x-show="recovery">
                                    <div class="col">
                                        <x-input-floating name="recovery_code" :messages="$errors->get('recovery_code')"/>
                                    </div>
                                    <div class="col text-end mt-auto">
                                        <button type="button" class="btn btn-link" x-cloak x-show="recovery" x-on:click="recovery = false;$nextTick(() => { $refs.code.focus() })">{{ __('Use an authentication code') }}</button>
                                    </div>
                                    <div class="col">
                                        <button class="btn btn-primary w-100" type="submit" wire:loading.attr="disabled" wire:loading.class="opacity-50">
                                            <span wire:loading wire:target="verify2FARecoveryCode" class="spinner-border spinner-border-sm me-2" aria-hidden="true"></span>
                                            {{ __('Login') }}
                                        </button>
                                    </div>
                                </form>
                                <div class="col text-center">
                                    <div>
                                        <form wire:submit.prevent="logout">
                                            <button type="submit" class="btn btn-link align-middle">Back to login</button>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="text-center mt-3">Designed by <a href="https://www.smart-tech.com" target="_blank">Smart Tech</a></div>
            </div>
        </div>
    </section>
    <x-toast on="response"></x-toast>
</div>
