<div>
    <div class="form-floating">
        <select  id="{{ $model }}-{{ $this->getId() }}"
            @if($multiple) multiple @endif
            wire:model="selected"
            name="selected"
            class="form-control">
            <option value="">Select {{ str_replace('_',' ',$model) }}</option>
            @foreach ($options as $key => $value)
                <option value="{{ $value['id'] }}" @if(is_array($selected) && in_array($value['id'], $selected)) selected @elseif($value['id'] == $selected) selected @endif>{!! $value['name'] !!}</option>
            @endforeach
        </select>
        <label for="{{ $model }}-{{ $this->getId() }}" class="text-capitalize">{{ str_replace('_',' ',$model) }}</label>
    </div>
</div>
@script
<script>
    $wire.on('updateChoices', (event) => {
        setTimeout(function () {
        let dropdown = document.getElementById('{{ $model }}-{{ $this->getId() }}');
            if (!dropdown.hasAttribute('data-choice')) {
                let choicesInstance = new Choices(dropdown, {
                    allowHTML: true,
                    removeItemButton: true,
                    placeholder:true,
                    placeholderValue: '',
                    searchPlaceholderValue: "Search...",
                    shouldSort: false,
                });
            }
            dropdown.addEventListener('change', (event) => {
                let selectedValues = Array.from(dropdown.selectedOptions).map(opt => opt.value);
                @this.set('selected', {{ $multiple ? 'selectedValues' : 'selectedValues[0]' }});
            });
        },0);
    }, { once: true });
</script>
@endscript
