<div>
    <section class="mb-3">
        <div class="row row-cols-1 row-cols-sm-2 row-cols-lg-3 g-2 g-lg-3">
            <div class="col">
                <h5 class="mb-0">Welcome <small class="fs-6">{{ Auth::user()->name }}</small></h5>
            </div>
            <div class="col">
                <div class="alert alert-primary alert-dismissible mb-0 ps-3 pe-3 p-2 d-none" role="alert">
                    <div class="pe-3">Nice, you triggered this alert message!</div>
                    <button type="button" class="btn-close p-2" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            </div>
        </div>
    </section>
    <section class="section dashboard">
        <div class="row">
            <div class="col-lg-8">
                <div class="row row-cols-1 row-cols-sm-2 row-cols-lg-3 g-3 g-lg-3">
                    @canany(['view_room','view_all'])
                    <div class="col">
                        <div class="card info-card sales-card shadow-sm">
                            <div class="card-body">
                                <div class="d-flex align-items-center mb-3">
                                    <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" class="bi bi-grid" viewBox="0 0 16 16">
                                            <path d="M1 2.5A1.5 1.5 0 0 1 2.5 1h3A1.5 1.5 0 0 1 7 2.5v3A1.5 1.5 0 0 1 5.5 7h-3A1.5 1.5 0 0 1 1 5.5zM2.5 2a.5.5 0 0 0-.5.5v3a.5.5 0 0 0 .5.5h3a.5.5 0 0 0 .5-.5v-3a.5.5 0 0 0-.5-.5zm6.5.5A1.5 1.5 0 0 1 10.5 1h3A1.5 1.5 0 0 1 15 2.5v3A1.5 1.5 0 0 1 13.5 7h-3A1.5 1.5 0 0 1 9 5.5zm1.5-.5a.5.5 0 0 0-.5.5v3a.5.5 0 0 0 .5.5h3a.5.5 0 0 0 .5-.5v-3a.5.5 0 0 0-.5-.5zM1 10.5A1.5 1.5 0 0 1 2.5 9h3A1.5 1.5 0 0 1 7 10.5v3A1.5 1.5 0 0 1 5.5 15h-3A1.5 1.5 0 0 1 1 13.5zm1.5-.5a.5.5 0 0 0-.5.5v3a.5.5 0 0 0 .5.5h3a.5.5 0 0 0 .5-.5v-3a.5.5 0 0 0-.5-.5zm6.5.5A1.5 1.5 0 0 1 10.5 9h3a1.5 1.5 0 0 1 1.5 1.5v3a1.5 1.5 0 0 1-1.5 1.5h-3A1.5 1.5 0 0 1 9 13.5zm1.5-.5a.5.5 0 0 0-.5.5v3a.5.5 0 0 0 .5.5h3a.5.5 0 0 0 .5-.5v-3a.5.5 0 0 0-.5-.5z"/>
                                        </svg>
                                    </div>
                                    <div class="mx-3 mt-1">
                                        <h5 class="card-title pb-1 mb-0">Rooms</h5>
                                        <h5 class="mb-0">{{ $users->total_users }}</h5>
                                    </div>
                                </div>
                                <div class="d-flex justify-content-between align-items-center">
                                    <div>
                                        <span class="alert alert-success small p-1">{{ $users->total_active_users }} Active</span>
                                        <span class="alert alert-danger small p-1">{{ $users->total_inactive_users }} InActive</span>
                                    </div>
                                    <a href="{{ route('user') }}" wire:navigate class="text-success small pt-1 fw-bold">View</a>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endcanany 
                    @canany(['view_award','view_all'])
                    <div class="col">
                        <div class="card info-card revenue-card shadow-sm">
                            <div class="card-body">
                                <div class="d-flex align-items-center mb-3">
                                    <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" class="bi bi-award" viewBox="0 0 16 16">
                                            <path d="M9.669.864 8 0 6.331.864l-1.858.282-.842 1.68-1.337 1.32L2.6 6l-.306 1.854 1.337 1.32.842 1.68 1.858.282L8 12l1.669-.864 1.858-.282.842-1.68 1.337-1.32L13.4 6l.306-1.854-1.337-1.32-.842-1.68zm1.196 1.193.684 1.365 1.086 1.072L12.387 6l.248 1.506-1.086 1.072-.684 1.365-1.51.229L8 10.874l-1.355-.702-1.51-.229-.684-1.365-1.086-1.072L3.614 6l-.25-1.506 1.087-1.072.684-1.365 1.51-.229L8 1.126l1.356.702z"/>
                                            <path d="M4 11.794V16l4-1 4 1v-4.206l-2.018.306L8 13.126 6.018 12.1z"/>
                                          </svg>
                                    </div>
                                    <div class="mx-3 mt-1">
                                        <h5 class="card-title pb-1 mb-0">Awards</h5>
                                        <h5 class="mb-0">{{ $users->total_users }}</h5>
                                    </div>
                                </div>
                                <div class="d-flex justify-content-between align-items-center">
                                    <div>
                                        <span class="alert alert-success small p-1">{{ $users->total_active_users }} Active</span>
                                        <span class="alert alert-danger small p-1">{{ $users->total_inactive_users }} InActive</span>
                                    </div>
                                    <a href="{{ route('user') }}" wire:navigate class="text-success small pt-1 fw-bold">View</a>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endcanany 
                    @canany(['view_offer','view_all'])
                    <div class="col">
                        <div class="card info-card customers-card shadow-sm">
                            <div class="card-body">
                                <div class="d-flex align-items-center mb-3">
                                    <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" class="bi bi-gift" viewBox="0 0 16 16">
                                            <path d="M3 2.5a2.5 2.5 0 0 1 5 0 2.5 2.5 0 0 1 5 0v.006c0 .07 0 .27-.038.494H15a1 1 0 0 1 1 1v2a1 1 0 0 1-1 1v7.5a1.5 1.5 0 0 1-1.5 1.5h-11A1.5 1.5 0 0 1 1 14.5V7a1 1 0 0 1-1-1V4a1 1 0 0 1 1-1h2.038A3 3 0 0 1 3 2.506zm1.068.5H7v-.5a1.5 1.5 0 1 0-3 0c0 .085.002.274.045.43zM9 3h2.932l.023-.07c.043-.156.045-.345.045-.43a1.5 1.5 0 0 0-3 0zM1 4v2h6V4zm8 0v2h6V4zm5 3H9v8h4.5a.5.5 0 0 0 .5-.5zm-7 8V7H2v7.5a.5.5 0 0 0 .5.5z"/>
                                          </svg>
                                    </div>
                                    <div class="mx-3 mt-1">
                                        <h5 class="card-title pb-1 mb-0">Offers & Promotions</h5>
                                        <h5 class="mb-0">{{ $roles->total_roles }}</h5>
                                    </div>
                                </div>
                                <div class="d-flex justify-content-between align-items-center">
                                    <div class="">
                                        <span class="text-danger small pt-1 fw-bold d-none">8%</span>
                                        <span class="text-muted small pt-2 ps-1 d-none">increase</span>
                                    </div>
                                    <a href="{{ route('role') }}" wire:navigate class="text-danger small pt-1 fw-bold">View</a>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endcanany 
                    @canany(['view_place','view_all'])
                    <div class="col">
                        <div class="card info-card sales-card shadow-sm">
                            <div class="card-body">
                                <div class="d-flex align-items-center mb-3">
                                    <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" class="bi bi-geo" viewBox="0 0 16 16">
                                            <path fill-rule="evenodd" d="M8 1a3 3 0 1 0 0 6 3 3 0 0 0 0-6M4 4a4 4 0 1 1 4.5 3.969V13.5a.5.5 0 0 1-1 0V7.97A4 4 0 0 1 4 3.999zm2.493 8.574a.5.5 0 0 1-.411.575c-.712.118-1.28.295-1.655.493a1.3 1.3 0 0 0-.37.265.3.3 0 0 0-.057.09V14l.002.008.016.033a.6.6 0 0 0 .145.15c.165.13.435.27.813.395.751.25 1.82.414 3.024.414s2.273-.163 3.024-.414c.378-.126.648-.265.813-.395a.6.6 0 0 0 .146-.15l.015-.033L12 14v-.004a.3.3 0 0 0-.057-.09 1.3 1.3 0 0 0-.37-.264c-.376-.198-.943-.375-1.655-.493a.5.5 0 1 1 .164-.986c.77.127 1.452.328 1.957.594C12.5 13 13 13.4 13 14c0 .426-.26.752-.544.977-.29.228-.68.413-1.116.558-.878.293-2.059.465-3.34.465s-2.462-.172-3.34-.465c-.436-.145-.826-.33-1.116-.558C3.26 14.752 3 14.426 3 14c0-.599.5-1 .961-1.243.505-.266 1.187-.467 1.957-.594a.5.5 0 0 1 .575.411"/>
                                          </svg>
                                    </div>
                                    <div class="mx-3 mt-1">
                                        <h5 class="card-title pb-1 mb-0">Places</h5>
                                        <h5 class="mb-0">{{ $users->total_users }}</h5>
                                    </div>
                                </div>
                                <div class="d-flex justify-content-between align-items-center">
                                    <div>
                                        <span class="alert alert-success small p-1">{{ $users->total_active_users }} Active</span>
                                        <span class="alert alert-danger small p-1">{{ $users->total_inactive_users }} InActive</span>
                                    </div>
                                    <a href="{{ route('user') }}" wire:navigate class="text-success small pt-1 fw-bold">View</a>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endcanany 
                    @canany(['view_gallery','view_all'])
                    <div class="col">
                        <div class="card info-card revenue-card shadow-sm">
                            <div class="card-body">
                                <div class="d-flex align-items-center mb-3">
                                    <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" class="bi bi-images" viewBox="0 0 16 16">
                                            <path d="M4.502 9a1.5 1.5 0 1 0 0-3 1.5 1.5 0 0 0 0 3"/>
                                            <path d="M14.002 13a2 2 0 0 1-2 2h-10a2 2 0 0 1-2-2V5A2 2 0 0 1 2 3a2 2 0 0 1 2-2h10a2 2 0 0 1 2 2v8a2 2 0 0 1-1.998 2M14 2H4a1 1 0 0 0-1 1h9.002a2 2 0 0 1 2 2v7A1 1 0 0 0 15 11V3a1 1 0 0 0-1-1M2.002 4a1 1 0 0 0-1 1v8l2.646-2.354a.5.5 0 0 1 .63-.062l2.66 1.773 3.71-3.71a.5.5 0 0 1 .577-.094l1.777 1.947V5a1 1 0 0 0-1-1z"/>
                                          </svg>
                                    </div>
                                    <div class="mx-3 mt-1">
                                        <h5 class="card-title pb-1 mb-0">Gallery</h5>
                                        <h5 class="mb-0">{{ $users->total_users }}</h5>
                                    </div>
                                </div>
                                <div class="d-flex justify-content-between align-items-center">
                                    <div>
                                        <span class="alert alert-success small p-1">{{ $users->total_active_users }} Active</span>
                                        <span class="alert alert-danger small p-1">{{ $users->total_inactive_users }} InActive</span>
                                    </div>
                                    <a href="{{ route('user') }}" wire:navigate class="text-success small pt-1 fw-bold">View</a>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endcanany 
                    @canany(['view_testimonial','view_all'])
                    <div class="col">
                        <div class="card info-card customers-card shadow-sm">
                            <div class="card-body">
                                <div class="d-flex align-items-center mb-3">
                                    <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" class="bi bi-list-check" viewBox="0 0 16 16">
                                            <path fill-rule="evenodd" d="M5 11.5a.5.5 0 0 1 .5-.5h9a.5.5 0 0 1 0 1h-9a.5.5 0 0 1-.5-.5m0-4a.5.5 0 0 1 .5-.5h9a.5.5 0 0 1 0 1h-9a.5.5 0 0 1-.5-.5m0-4a.5.5 0 0 1 .5-.5h9a.5.5 0 0 1 0 1h-9a.5.5 0 0 1-.5-.5M3.854 2.146a.5.5 0 0 1 0 .708l-1.5 1.5a.5.5 0 0 1-.708 0l-.5-.5a.5.5 0 1 1 .708-.708L2 3.293l1.146-1.147a.5.5 0 0 1 .708 0m0 4a.5.5 0 0 1 0 .708l-1.5 1.5a.5.5 0 0 1-.708 0l-.5-.5a.5.5 0 1 1 .708-.708L2 7.293l1.146-1.147a.5.5 0 0 1 .708 0m0 4a.5.5 0 0 1 0 .708l-1.5 1.5a.5.5 0 0 1-.708 0l-.5-.5a.5.5 0 0 1 .708-.708l.146.147 1.146-1.147a.5.5 0 0 1 .708 0"/>
                                          </svg>
                                    </div>
                                    <div class="mx-3 mt-1">
                                        <h5 class="card-title pb-1 mb-0">Testimonials</h5>
                                        <h5 class="mb-0">{{ $roles->total_roles }}</h5>
                                    </div>
                                </div>
                                <div class="d-flex justify-content-between align-items-center">
                                    <div class="">
                                        <span class="text-danger small pt-1 fw-bold d-none">8%</span>
                                        <span class="text-muted small pt-2 ps-1 d-none">increase</span>
                                    </div>
                                    <a href="{{ route('role') }}" wire:navigate class="text-danger small pt-1 fw-bold">View</a>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endcanany 
                    @canany(['view_user','view_all'])
                    <div class="col">
                        <div class="card info-card revenue-card shadow-sm">
                            <div class="card-body">
                                <div class="d-flex align-items-center mb-3">
                                    <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" class="bi bi-people" viewBox="0 0 16 16">
                                            <path d="M15 14s1 0 1-1-1-4-5-4-5 3-5 4 1 1 1 1zm-7.978-1L7 12.996c.001-.264.167-1.03.76-1.72C8.312 10.629 9.282 10 11 10c1.717 0 2.687.63 3.24 1.276.593.69.758 1.457.76 1.72l-.008.002-.014.002zM11 7a2 2 0 1 0 0-4 2 2 0 0 0 0 4m3-2a3 3 0 1 1-6 0 3 3 0 0 1 6 0M6.936 9.28a6 6 0 0 0-1.23-.247A7 7 0 0 0 5 9c-4 0-5 3-5 4q0 1 1 1h4.216A2.24 2.24 0 0 1 5 13c0-1.01.377-2.042 1.09-2.904.243-.294.526-.569.846-.816M4.92 10A5.5 5.5 0 0 0 4 13H1c0-.26.164-1.03.76-1.724.545-.636 1.492-1.256 3.16-1.275ZM1.5 5.5a3 3 0 1 1 6 0 3 3 0 0 1-6 0m3-2a2 2 0 1 0 0 4 2 2 0 0 0 0-4"/>
                                          </svg>
                                    </div>
                                    <div class="mx-3 mt-1">
                                        <h5 class="card-title pb-1 mb-0">Employees</h5>
                                        <h5 class="mb-0">{{ $users->total_users }}</h5>
                                    </div>
                                </div>
                                <div class="d-flex justify-content-between align-items-center">
                                    <div>
                                        <span class="alert alert-success small p-1">{{ $users->total_active_users }} Active</span>
                                        <span class="alert alert-danger small p-1">{{ $users->total_inactive_users }} InActive</span>
                                    </div>
                                    <a href="{{ route('user') }}" wire:navigate class="text-success small pt-1 fw-bold">View</a>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endcanany 
                    @canany(['view_role','view_all'])
                    <div class="col">
                        <div class="card info-card customers-card shadow-sm">
                            <div class="card-body">
                                <div class="d-flex align-items-center mb-3">
                                    <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" class="bi bi-bar-chart-steps" viewBox="0 0 16 16">
                                            <path d="M.5 0a.5.5 0 0 1 .5.5v15a.5.5 0 0 1-1 0V.5A.5.5 0 0 1 .5 0M2 1.5a.5.5 0 0 1 .5-.5h4a.5.5 0 0 1 .5.5v1a.5.5 0 0 1-.5.5h-4a.5.5 0 0 1-.5-.5zm2 4a.5.5 0 0 1 .5-.5h7a.5.5 0 0 1 .5.5v1a.5.5 0 0 1-.5.5h-7a.5.5 0 0 1-.5-.5zm2 4a.5.5 0 0 1 .5-.5h6a.5.5 0 0 1 .5.5v1a.5.5 0 0 1-.5.5h-6a.5.5 0 0 1-.5-.5zm2 4a.5.5 0 0 1 .5-.5h7a.5.5 0 0 1 .5.5v1a.5.5 0 0 1-.5.5h-7a.5.5 0 0 1-.5-.5z"></path>
                                        </svg>
                                    </div>
                                    <div class="mx-3 mt-1">
                                        <h5 class="card-title pb-1 mb-0">Roles</h5>
                                        <h5 class="mb-0">{{ $roles->total_roles }}</h5>
                                    </div>
                                </div>
                                <div class="d-flex justify-content-between align-items-center">
                                    <div class="">
                                        <span class="text-danger small pt-1 fw-bold d-none">8%</span>
                                        <span class="text-muted small pt-2 ps-1 d-none">increase</span>
                                    </div>
                                    <a href="{{ route('role') }}" wire:navigate class="text-danger small pt-1 fw-bold">View</a>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endcanany 
                    @canany(['view_permission','view_all'])
                    <div class="col">
                        <div class="card info-card sales-card shadow-sm">
                            <div class="card-body">
                                <div class="d-flex align-items-center mb-3">
                                    <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" class="bi bi-key" viewBox="0 0 16 16">
                                            <path d="M0 8a4 4 0 0 1 7.465-2H14a.5.5 0 0 1 .354.146l1.5 1.5a.5.5 0 0 1 0 .708l-1.5 1.5a.5.5 0 0 1-.708 0L13 9.207l-.646.647a.5.5 0 0 1-.708 0L11 9.207l-.646.647a.5.5 0 0 1-.708 0L9 9.207l-.646.647A.5.5 0 0 1 8 10h-.535A4 4 0 0 1 0 8m4-3a3 3 0 1 0 2.712 4.285A.5.5 0 0 1 7.163 9h.63l.853-.854a.5.5 0 0 1 .708 0l.646.647.646-.647a.5.5 0 0 1 .708 0l.646.647.646-.647a.5.5 0 0 1 .708 0l.646.647.793-.793-1-1h-6.63a.5.5 0 0 1-.451-.285A3 3 0 0 0 4 5"/>
                                            <path d="M4 8a1 1 0 1 1-2 0 1 1 0 0 1 2 0"/>
                                          </svg>
                                    </div>
                                    <div class="mx-3 mt-1">
                                        <h5 class="card-title pb-1 mb-0">Permisions</h5>
                                        <h5 class="mb-0">{{ $modules->total_modules }}</h5>
                                    </div>
                                </div>
                                <div class="d-flex justify-content-between align-items-center">
                                    <div class="">
                                        <span class="text-danger small pt-1 fw-bold d-none">8%</span>
                                        <span class="text-muted small pt-2 ps-1 d-none">increase</span>
                                    </div>
                                    <a href="{{ route('role') }}" wire:navigate class="text-danger small pt-1 fw-bold">View</a>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endcanany
                    <div class="col-12">
                        <div class="card mb-3 shadow-sm">
                            <div class="card-header py-3">
                                <div class="fs-6 text-body-tertiary">Expenses <small>/ This year</small></div>
                            </div>
                            <div class="card-body">
                                
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-4">
                @canany(['loginhistory_view','view_all'])
                <div class="card mb-3 shadow-sm">
                    <div class="card-header d-flex justify-content-between align-items-center py-3">
                        <div class="fs-6 text-body-tertiary">User Login History</div>
                        <small class="text-body-tertiary">
                            (@if(request()->start || request()->end) <span class="text-danger bold">From</span> {{ date('d M y', strtotime(request()->start)) }} <span class="text-danger bold">To</span> {{ date('d M y',strtotime(request()->end)) }} @else This month @endif)
                        </small>
                    </div>
                    <div class="card-body">
                        <div class="activity">
                            <div class="activity-item d-flex">
                                <div class="activite-label">32 min</div>
                                <i class="bi bi-circle-fill activity-badge text-success align-self-start"></i>
                                <div class="activity-content">Quia quae rerum <a href="#" class="fw-bold text-dark">explicabo officiis</a> beatae</div>
                            </div>
                            <!-- End activity item-->

                            <div class="activity-item d-flex">
                                <div class="activite-label">56 min</div>
                                <i class="bi bi-circle-fill activity-badge text-danger align-self-start"></i>
                                <div class="activity-content">
                                    Voluptatem blanditiis blanditiis eveniet
                                </div>
                            </div>
                            <!-- End activity item-->

                            <div class="activity-item d-flex">
                                <div class="activite-label">2 hrs</div>
                                <i class="bi bi-circle-fill activity-badge text-primary align-self-start"></i>
                                <div class="activity-content">
                                    Voluptates corrupti molestias voluptatem
                                </div>
                            </div>
                            <!-- End activity item-->

                            <div class="activity-item d-flex">
                                <div class="activite-label">1 day</div>
                                <i class="bi bi-circle-fill activity-badge text-info align-self-start"></i>
                                <div class="activity-content">Tempore autem saepe <a href="#" class="fw-bold text-dark">occaecati voluptatem</a> tempore</div>
                            </div>
                            <!-- End activity item-->

                            <div class="activity-item d-flex">
                                <div class="activite-label">2 days</div>
                                <i class="bi bi-circle-fill activity-badge text-warning align-self-start"></i>
                                <div class="activity-content">
                                    Est sit eum reiciendis exercitationem
                                </div>
                            </div>
                            <!-- End activity item-->

                            <div class="activity-item d-flex">
                                <div class="activite-label">4 weeks</div>
                                <i class="bi bi-circle-fill activity-badge text-muted align-self-start"></i>
                                <div class="activity-content">
                                    Dicta dolorem harum nulla eius. Ut quidem quidem sit quas
                                </div>
                            </div>
                            <!-- End activity item-->
                        </div>
                    </div>
                </div>
                @endcanany
                <div class="card mb-3 shadow-sm">
                    <div class="card-header py-3">
                        <div class="fs-6 text-body-tertiary">News &amp; Updates <small>| Today</small></div>
                    </div>
                    <div class="filter">
                        <a class="icon" href="#" data-bs-toggle="dropdown"><i class="bi bi-three-dots"></i></a>
                        <ul class="dropdown-menu dropdown-menu-end dropdown-menu-arrow">
                            <li class="dropdown-header text-start">
                                <h6>Filter</h6>
                            </li>
                            <li><a class="dropdown-item" href="#">Today</a></li>
                            <li><a class="dropdown-item" href="#">This Month</a></li>
                            <li><a class="dropdown-item" href="#">This Year</a></li>
                        </ul>
                    </div>
                    <div class="card-body">
                        <div class="row row-cols-1 row-cols-sm-1 g-3 g-lg-3">
                            <div class="col">
                                <div class="d-inline-flex align-items-center">
                                    <img src="{{ asset('storage/defaults/photo.webp') }}" width="80px" alt="..." />
                                    <div class="ms-3">
                                        <div class="d-flex justify-content-between align-items-center">
                                            <a href="javascript:void(0);" class="fs-6">Laborum corporis quo dara net para</a>
                                            <div class="fw-light small text-muted">15 Sep 2024</div>
                                        </div>
                                        <p class="text-muted small mb-0 d-block">Sit recusandae non aspernatur laboriosam. Quia enim eligendi sed ut harum Sit recusandae non aspernatur laboriosam. Quia enim eligendi sed ut harum</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col">
                                <div class="d-inline-flex align-items-center">
                                    <img src="{{ asset('storage/defaults/photo.webp') }}" width="80px" alt="..." />
                                    <div class="ms-3">
                                        <div class="d-flex justify-content-between align-items-center">
                                            <a href="javascript:void(0);" class="fs-6">Laborum corporis quo dara net para</a>
                                            <div class="fw-light small text-muted">15 Sep 2024</div>
                                        </div>
                                        <p class="text-muted small mb-0 d-block">Sit recusandae non aspernatur laboriosam. Quia enim eligendi sed ut harum Sit recusandae non aspernatur laboriosam. Quia enim eligendi sed ut harum</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col">
                                <div class="d-inline-flex align-items-center">
                                    <img src="{{ asset('storage/defaults/photo.webp') }}" width="80px" alt="..." />
                                    <div class="ms-3">
                                        <div class="d-flex justify-content-between align-items-center">
                                            <a href="javascript:void(0);" class="fs-6">Laborum corporis quo dara net para</a>
                                            <div class="fw-light small text-muted">15 Sep 2024</div>
                                        </div>
                                        <p class="text-muted small mb-0 d-block">Sit recusandae non aspernatur laboriosam. Quia enim eligendi sed ut harum Sit recusandae non aspernatur laboriosam. Quia enim eligendi sed ut harum</p>
                                    </div>
                                </div>
                            </div>
                            <div class="col">
                                <div class="d-inline-flex align-items-center">
                                    <img src="{{ asset('storage/defaults/photo.webp') }}" width="80px" alt="..." />
                                    <div class="ms-3">
                                        <div class="d-flex justify-content-between align-items-center">
                                            <a href="javascript:void(0);" class="fs-6">Laborum corporis quo dara net para</a>
                                            <div class="fw-light small text-muted">15 Sep 2024</div>
                                        </div>
                                        <p class="text-muted small mb-0 d-block">Sit recusandae non aspernatur laboriosam. Quia enim eligendi sed ut harum Sit recusandae non aspernatur laboriosam. Quia enim eligendi sed ut harum</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-footer text-center py-3">
                        <a href="javascript:void(0);">View all news and updates</a>
                    </div>
                </div>
            </div>
            <!-- End Right side columns -->
        </div>
    </section>
</div>
