<div>
    <section class="mb-3">
        <div class="row row-cols-1 row-cols-sm-2 row-cols-lg-2 g-2 g-lg-3">
            <div class="col">
                <h5 class="mb-0">User Login History <small class="fs-6">List</small></h5>
            </div>
            <div class="col">
                {{-- <div class="alert alert-primary alert-dismissible mb-0 ps-3 pe-3 p-2" role="alert">
                    <div class="pe-3">Nice, you triggered this alert message!</div>
                    <button type="button" class="btn-close p-2" data-bs-dismiss="alert" aria-label="Close"></button>
                </div> --}}
            </div>
          </div>
    </section>
    <section x-data="{deleteId:[]}" class="content">
        <div x-data="{ filter: localStorage.getItem('filter') || 'show' }" class="accordion" id="accordionPanelsStayOpenExample">
            <div class="accordion-item rounded-top rounded-bottom-0 border-0">
              <h2 class="accordion-header p-2 d-flex" id="panelsStayOpen-headingOne">
                <button @click="filter = filter === 'show' ? 'hide' : 'show'; localStorage.setItem('filter', filter)" class="accordion-button shadow-none  p-1" type="button" data-bs-toggle="collapse" data-bs-target="#panelsStayOpen-collapseOne" aria-expanded="true" aria-controls="panelsStayOpen-collapseOne">
                    <i class="bi bi-funnel me-1"></i> Filter
                </button>
                <a href="{{ route('login.history') }}" wire:navigate class="btn btn-light border-light-subtle text-nowrap" role="button">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-arrow-repeat" viewBox="0 0 16 16">
                        <path d="M11.534 7h3.932a.25.25 0 0 1 .192.41l-1.966 2.36a.25.25 0 0 1-.384 0l-1.966-2.36a.25.25 0 0 1 .192-.41m-11 2h3.932a.25.25 0 0 0 .192-.41L2.692 6.23a.25.25 0 0 0-.384 0L.342 8.59A.25.25 0 0 0 .534 9"/>
                        <path fill-rule="evenodd" d="M8 3c-1.552 0-2.94.707-3.857 1.818a.5.5 0 1 1-.771-.636A6.002 6.002 0 0 1 13.917 7H12.9A5 5 0 0 0 8 3M3.1 9a5.002 5.002 0 0 0 8.757 2.182.5.5 0 1 1 .771.636A6.002 6.002 0 0 1 2.083 9z"/>
                    </svg>
                    Reload
                </a>
            </h2>
              <div id="panelsStayOpen-collapseOne" class="accordion-collapse collapse" :class="filter" aria-labelledby="panelsStayOpen-headingOne">
                <div class="accordion-body border-top px-3">
                        <div class="row row-cols-2 row-cols-lg-4 g-3 g-lg-3">
                            <div class="col grid-select-all-btn d-none">
                                <div class="btn-group w-100">
                                    @canany(['delete_loginhistory','delete_all'])
                                    <button type="button" class="btn border dropdown-toggle dropdown-toggle-split" data-bs-toggle="dropdown" aria-expanded="false">
                                        <i class="bi bi-chevron-down ms-auto"></i>
                                    </button>
                                    <ul class="dropdown-menu">
                                        <li>
                                            <button class="dropdown-item text-danger" x-on:click="deleteId" data-bs-toggle="modal" data-bs-target="#confirmModal">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-trash3 fs-6" viewBox="0 0 16 16">
                                                    <path d="M6.5 1h3a.5.5 0 0 1 .5.5v1H6v-1a.5.5 0 0 1 .5-.5M11 2.5v-1A1.5 1.5 0 0 0 9.5 0h-3A1.5 1.5 0 0 0 5 1.5v1H1.5a.5.5 0 0 0 0 1h.538l.853 10.66A2 2 0 0 0 4.885 16h6.23a2 2 0 0 0 1.994-1.84l.853-10.66h.538a.5.5 0 0 0 0-1zm1.958 1-.846 10.58a1 1 0 0 1-.997.92h-6.23a1 1 0 0 1-.997-.92L3.042 3.5zm-7.487 1a.5.5 0 0 1 .528.47l.5 8.5a.5.5 0 0 1-.998.06L5 5.03a.5.5 0 0 1 .47-.53Zm5.058 0a.5.5 0 0 1 .47.53l-.5 8.5a.5.5 0 1 1-.998-.06l.5-8.5a.5.5 0 0 1 .528-.47M8 4.5a.5.5 0 0 1 .5.5v8.5a.5.5 0 0 1-1 0V5a.5.5 0 0 1 .5-.5"/>
                                                </svg> 
                                            Bulk Delete
                                            </button>
                                        </li>
                                    </ul>
                                    @endcanany
                                    <button type="button" class="btn border selected w-100">10 selected</button>
                                    <button type="button" class="btn border dropdown-toggle dropdown-toggle-split" data-bs-toggle="dropdown" aria-expanded="false">
                                        <i class="bi bi-chevron-down ms-auto"></i>
                                    </button>
                                    <ul class="dropdown-menu">
                                        <li><a class="dropdown-item grid-batch-0 text-secondary" href="javascript:void(0);" onclick="printThis('{{ route('login-history.export','print') }}')"><i class="bi bi-printer-fill fs-6"></i> Print</a></li>
                                        <li><a class="dropdown-item grid-batch-0 text-info" href="javascript:void(0);" onclick="exportRecords('{{ route('login-history.export','csv') }}')"><i class="bi bi-filetype-csv fs-6"></i> Export CSV</a></li>
                                        <li><a class="dropdown-item grid-batch-0 text-success" href="javascript:void(0);" onclick="exportRecords('{{ route('login-history.export','excel') }}')"><i class="bi bi-filetype-exe fs-6"></i> Export Excel</a></li>
                                    </ul>
                                  </div>
                            </div>
                            <div class="col">
                                <x-input-floating model=".live.debounce.300ms" name="search" placeholder="Search..." />
                            </div>
                            <div class="col">
                                <livewire:admin.choices-component model="user" :options="$users" :selected="$user" :multiple="false"/>
                            </div>
                            
                        </div>
                </div>
              </div>
            </div>
          </div>
            <div class="row">
                    <div class="col-md-12">
                        <div class="shadow-sm rounded-bottom position-relative mb-3 w-100">
                            <div class="table-responsive rounded">
                                <table class="table table-hover mb-0">
                                    <thead class="table-light">
                                        <tr>
                                            <th>
                                                <div class="form-check ms-2">
                                                    <x-input-floating type="checkbox" name="" class="form-check-input" onclick="selectAll();" value="" id="selectAll"/>
                                                </div>
                                            </th>
                                            <th>ID</th>
                                            <th>User</th>
                                            <th>City</th>
                                            <th>Country</th>
                                            <th>Country Code</th>
                                            <th>Region</th>
                                            <th>Region Code</th>
                                            <th>Timezone</th>
                                            <th>Postal Code</th>
                                            <th>IP Address</th>
                                            <th>Lat/Lng</th>
                                            <th>Device</th>
                                            <th>Created At</th>
                                            @canany(['delete_loginhistory','delete_all'])
                                            <th>Action</th>
                                            @endcanany
                                        </tr>
                                    </thead>
    
                                    <tbody>
                                        @if($collection->count())
                                        @foreach($collection as  $item)
                                        <tr data-key="{{ $item->id }}">
                                            <td>
                                                <div class="form-check ms-2">
                                                    <x-input-floating type="checkbox" name="" class="grid-row-checkbox" onclick="rowCheckbox(this);" value="{{ $item->id }}" id="{{ $item->id }}"/>
                                                </div>
                                            </td>
                                            <td>{{ $item->id }}</td>
                                            <td>
                                                @if($item->user->exists)
                                                <div class="d-inline-flex align-middle align-items-center">
                                                    <a href="" class="me-2">
                                                        @if(!empty($item->user->image) && Storage::disk('public')->exists(str_replace('storage/','',$item->user->image)))
                                                        <img class="rounded-circle border shadow-sm d-block" src="{{asset($item->user->image)}}" width="40px" alt="...">
                                                        @else
                                                        <img class="rounded-circle border shadow-sm d-block" src="{{asset('storage/defaults/user.webp')}}" width="40px" alt="...">
                                                        @endif
                                                    </a>
                                                    <div>
                                                        <a href="">
                                                            {{ $item->user->name }}
                                                            <small class="text-muted d-block">Last active {{ $item->created_at->diffForHumans() ?? '' }}</small>
                                                        </a>
                                                        
                                                    </div>
                                                    
                                                    
                                                </div>
                                                @endif
                                            </td>
                                            <td>{{ $item->city }}</td>
                                            <td>{{ $item->country }}</td>
                                            <td>{{ $item->country_code }}</td>
                                            <td>{{ $item->region }}</td>
                                            <td>{{ $item->region_code }}</td>
                                            <td>{{ $item->timezone }}</td>
                                            <td>{{ $item->postal_code }}</td>
                                            <td>{{ $item->ip }}</td>
                                            <td>
                                                <a href="https://www.google.com/maps/place/{{ $item->latitude }},{{ $item->longitude }}/@{{ $item->latitude }},{{ $item->longitude }}" target="_blank">{{ $item->latitude }}</a><br>
                                                <a href="https://www.google.com/maps/place/{{ $item->latitude }},{{ $item->longitude }}/@{{ $item->latitude }},{{ $item->longitude }}" target="_blank">{{ $item->longitude }}</a>
                                            </td>
                                            <td>{{ $item->device }}</td>
                                            <td><small>{{ date('d M Y / h:i a',strtotime($item->created_at)) }}<br>{{ date('d M Y / h:i a',strtotime($item->updated_at)) }}</small></td>
                                            @canany(['delete_loginhistory','delete_all'])
                                            <td>
                                               <a href="javascript:void(0);" data-bs-toggle="modal" data-bs-target="#confirmModal" x-on:click="deleteId=[{{ $item->id }}]" class="text-danger" data-bs-tooltip="tooltip" data-bs-placement="top" data-bs-custom-class="tooltip-danger" data-bs-title="Delete Record">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="35" height="35" fill="currentColor" class="bi bi-trash" viewBox="0 0 16 16">
                                                    <path d="M5.5 5.5A.5.5 0 0 1 6 6v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5m2.5 0a.5.5 0 0 1 .5.5v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5m3 .5a.5.5 0 0 0-1 0v6a.5.5 0 0 0 1 0z"/>
                                                    <path d="M14.5 3a1 1 0 0 1-1 1H13v9a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V4h-.5a1 1 0 0 1-1-1V2a1 1 0 0 1 1-1H6a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1h3.5a1 1 0 0 1 1 1zM4.118 4 4 4.059V13a1 1 0 0 0 1 1h6a1 1 0 0 0 1-1V4.059L11.882 4zM2.5 3h11V2h-11z"/>
                                                </svg>
                                               </a>
                                            </td>
                                            @endcanany
                                        </tr>
                                        @endforeach
                                        @else
                                        <tr>
                                            <td class="text-center" colspan="15">No record Found</td>
                                        </tr>
                                        @endif
                                    </tbody>
    
                                </table>
                            </div>
                            {{$collection->onEachSide(1)->links('components.layouts.pagination')}}
    
                        </div>
                    </div>
                </div>
                <!-- Confirm Modal Modal -->
    @include('components.layouts.confirm-modal')
    </section>
<x-toast on="response"></x-toast>
</div>
@script
<script>
    $wire.on('hideModal', (event) => {
        setTimeout(function () {
            const modalElement = document.getElementById(event[0].modal);
            const modal = bootstrap.Modal.getInstance(modalElement);
            modal.hide();
            Livewire.dispatch(event[0].modal);
        },0);
    });
</script>
@endscript