<div>
    @if($editModal)
    <div class="modal fade" id="editModal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="editModalLabel" aria-hidden="true" wire:ignore.self>
        <div class="modal-dialog modal-xl">
            <div class="modal-content">
                <form wire:submit="update({{ $page->id}})" accept-charset="UTF-8" enctype="multipart/form-data" novalidate>
                    <div class="modal-header">
                        <div class="modal-title fs-6">Update Page</div>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" wire:click="$dispatch('editModal')"></button>
                    </div>
                    <div class="modal-body mx-md-4">
                        <div class="mb-3">
                            <x-input-floating name="title" :messages="$errors->get('title')"/>
                        </div>
                        <div class="mb-3">
                            <x-textarea-floating name="description" id="tinymce-editor" :messages="$errors->get('description')" placeholder="Start writing here..." style="min-height:100px;"/>
                        </div>
                    </div>
                    <div class="modal-footer justify-content-between">
                        <button type="reset" class="btn btn-warning">Reset</button>
                        <div>
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal" wire:click="$dispatch('editModal')">Close</button>
                            <button type="submit" class="btn btn-primary"  wire:loading.attr="disabled" wire:loading.class="opacity-50">
                                <span wire:loading wire:target="update({{ $page->id}})" class="spinner-border spinner-border-sm me-2" aria-hidden="true"></span>
                                {{ __('Submit') }}
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
    @endif
</div>