<div>
    <section class="mb-3">
        <div class="row row-cols-1 row-cols-sm-2 row-cols-lg-2 g-2 g-lg-3">
            <div class="col">
                <h5 class="mb-0">Permissions <small class="fs-6">List</small></h5>
            </div>
            <div class="col">
                {{-- <div class="alert alert-primary alert-dismissible mb-0 ps-3 pe-3 p-2" role="alert">
                    <div class="pe-3">Nice, you triggered this alert message!</div>
                    <button type="button" class="btn-close p-2" data-bs-dismiss="alert" aria-label="Close"></button>
                </div> --}}
            </div>
          </div>
    </section>
    <section x-data="{deleteId:[]}" class="content">
        <div x-data="{ filter: localStorage.getItem('filter') || 'show' }" class="accordion" id="accordionPanelsStayOpenExample">
            <div class="accordion-item rounded-top rounded-bottom-0 border-0">
              <h2 class="accordion-header p-2 d-flex" id="panelsStayOpen-headingOne">
                <button @click="filter = filter === 'show' ? 'hide' : 'show'; localStorage.setItem('filter', filter)" class="accordion-button shadow-none  p-1" type="button" data-bs-toggle="collapse" data-bs-target="#panelsStayOpen-collapseOne" aria-expanded="true" aria-controls="panelsStayOpen-collapseOne">
                    <i class="bi bi-funnel me-1"></i> Filter
                </button>
                <a href="{{ route('permission') }}" wire:navigate class="btn btn-light border-light-subtle text-nowrap me-1" role="button">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-arrow-repeat" viewBox="0 0 16 16">
                        <path d="M11.534 7h3.932a.25.25 0 0 1 .192.41l-1.966 2.36a.25.25 0 0 1-.384 0l-1.966-2.36a.25.25 0 0 1 .192-.41m-11 2h3.932a.25.25 0 0 0 .192-.41L2.692 6.23a.25.25 0 0 0-.384 0L.342 8.59A.25.25 0 0 0 .534 9"/>
                        <path fill-rule="evenodd" d="M8 3c-1.552 0-2.94.707-3.857 1.818a.5.5 0 1 1-.771-.636A6.002 6.002 0 0 1 13.917 7H12.9A5 5 0 0 0 8 3M3.1 9a5.002 5.002 0 0 0 8.757 2.182.5.5 0 1 1 .771.636A6.002 6.002 0 0 1 2.083 9z"/>
                    </svg>
                    Reload
                </a>
                @canany(['create_permission','create_all'])
                <button type="button" class="btn btn-success text-nowrap" wire:click="create" wire:loading.attr="disabled" wire:loading.class="opacity-50">
                    <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" fill="currentColor" class="bi bi-plus-lg" viewBox="0 0 16 16">
                        <path fill-rule="evenodd" d="M8 2a.5.5 0 0 1 .5.5v5h5a.5.5 0 0 1 0 1h-5v5a.5.5 0 0 1-1 0v-5h-5a.5.5 0 0 1 0-1h5v-5A.5.5 0 0 1 8 2"></path>
                    </svg>
                    <span wire:loading wire:target="create" class="spinner-border spinner-border-sm me-2" aria-hidden="true"></span>
                    New
                </button>
                @endcanany
            </h2>
              <div id="panelsStayOpen-collapseOne" class="accordion-collapse collapse " :class="filter" aria-labelledby="panelsStayOpen-headingOne">
                <div class="accordion-body border-top px-3">
                        <div class="row row-cols-1 row-cols-lg-4 g-3 g-lg-3">
                            <div class="col grid-select-all-btn d-none">
                                <div class="btn-group w-100">
                                    @canany(['delete_permission','delete_all'])
                                    <button type="button" class="btn border dropdown-toggle dropdown-toggle-split" data-bs-toggle="dropdown" aria-expanded="false">
                                        <i class="bi bi-chevron-down ms-auto"></i>
                                    </button>
                                    <ul class="dropdown-menu">
                                        <li>
                                            <button class="dropdown-item text-danger" x-on:click="deleteId" data-bs-toggle="modal" data-bs-target="#confirmModal">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-trash3 fs-6" viewBox="0 0 16 16">
                                                    <path d="M6.5 1h3a.5.5 0 0 1 .5.5v1H6v-1a.5.5 0 0 1 .5-.5M11 2.5v-1A1.5 1.5 0 0 0 9.5 0h-3A1.5 1.5 0 0 0 5 1.5v1H1.5a.5.5 0 0 0 0 1h.538l.853 10.66A2 2 0 0 0 4.885 16h6.23a2 2 0 0 0 1.994-1.84l.853-10.66h.538a.5.5 0 0 0 0-1zm1.958 1-.846 10.58a1 1 0 0 1-.997.92h-6.23a1 1 0 0 1-.997-.92L3.042 3.5zm-7.487 1a.5.5 0 0 1 .528.47l.5 8.5a.5.5 0 0 1-.998.06L5 5.03a.5.5 0 0 1 .47-.53Zm5.058 0a.5.5 0 0 1 .47.53l-.5 8.5a.5.5 0 1 1-.998-.06l.5-8.5a.5.5 0 0 1 .528-.47M8 4.5a.5.5 0 0 1 .5.5v8.5a.5.5 0 0 1-1 0V5a.5.5 0 0 1 .5-.5"/>
                                                </svg> 
                                            Bulk Delete
                                            </button>
                                        </li>
                                    </ul>
                                    @endcanany
                                    <button type="button" class="btn border selected w-100">10 selected</button>
                                    <button type="button" class="btn border dropdown-toggle dropdown-toggle-split" data-bs-toggle="dropdown" aria-expanded="false">
                                        <i class="bi bi-chevron-down ms-auto"></i>
                                    </button>
                                    <ul class="dropdown-menu">
                                        <li><a class="dropdown-item grid-batch-0 text-secondary" href="javascript:void(0);" onclick="printThis('{{ route('permission','print') }}')"><i class="bi bi-printer-fill fs-6"></i> Print</a></li>
                                        <li><a class="dropdown-item grid-batch-0 text-info" href="javascript:void(0);" onclick="exportRecords('{{ route('permission','csv') }}')"><i class="bi bi-filetype-csv fs-6"></i> Export CSV</a></li>
                                        <li><a class="dropdown-item grid-batch-0 text-success" href="javascript:void(0);" onclick="exportRecords('{{ route('permission','excel') }}')"><i class="bi bi-filetype-exe fs-6"></i> Export Excel</a></li>
                                    </ul>
                                  </div>
                            </div>
                            <div class="col">
                                <div class="form-floating">
                                    <input wire:model.live.debounce.300ms="search" name="search" class="form-control" id="floatingInputGroup1" placeholder="Search...">
                                    <label for="floatingInputGroup1">Search...</label>
                                </div>
                            </div>
                            
                        </div>
                     
                </div>
              </div>
            </div>
          </div>
            <div class="row">
                    <div class="col-md-12">
                        <div class="shadow-sm rounded-bottom position-relative bg-whi  w-100">
                            <div class="table-responsive rounded">
                                <table class="table table-hover mb-0">
                                    <thead class="table-light">
                                        <tr>
                                            <th>
                                                <div class="form-check ms-2">
                                                    <x-input-floating type="checkbox" name="" class="form-check-input" onclick="selectAll();" value="" id="selectAll"/>
                                                </div>
                                            </th>
                                            <th>ID</th>
                                            <th>Module</th>
                                            <th>Permissions</th>
                                            <th>Created/Updated At</th>
                                            @canany(['update_permission','delete_permission','update_all','delete_all'])
                                            <th>Action</th>
                                            @endcanany
                                        </tr>
                                    </thead>
                                    @if($collection->isNotEmpty())
                                    <tbody>
                                        @foreach($collection as  $item)
                                        <tr data-key="{{ $item->id }}">
                                            <td>
                                                <div class="form-check ms-2">
                                                    <x-input-floating type="checkbox" name="" class="grid-row-checkbox" onclick="rowCheckbox(this);" value="{{ $item->id }}" id="{{ $item->id }}"/>
                                                </div>
                                            </td>
                                            <td>{{ $item->id }}</td>
                                            <td>{{ $item->name }}</td>
                                            <td>
                                                @if(count($item->permissions)>0)
                                                    @foreach($item->permissions as $permission)
                                                        @if(str_contains($permission->name,'view')) 
                                                            <span class="alert alert-success cursor-pointer py-1 px-2 text-center me-1" tabindex="0" data-bs-toggle="popover" data-bs-placement="top" data-bs-trigger="hover focus" data-bs-content="User will be able only view the data for this module '{{ $item->name }}' ">
                                                                {{ str_replace('_'.strtolower($item->name),'',$permission->name) }}
                                                                <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" fill="currentColor" class="bi bi-info-circle text-success" viewBox="0 0 16 16">
                                                                    <path d="M8 15A7 7 0 1 1 8 1a7 7 0 0 1 0 14m0 1A8 8 0 1 0 8 0a8 8 0 0 0 0 16"/>
                                                                    <path d="m8.93 6.588-2.29.287-.082.38.45.083c.294.07.352.176.288.469l-.738 3.468c-.194.897.105 1.319.808 1.319.545 0 1.178-.252 1.465-.598l.088-.416c-.2.176-.492.246-.686.246-.275 0-.375-.193-.304-.533zM9 4.5a1 1 0 1 1-2 0 1 1 0 0 1 2 0"/>
                                                                </svg>
                                                                
                                                            </span>
                                                        @elseif (str_contains($permission->name,'create'))
                                                            <span class="alert alert-primary cursor-pointer py-1 px-2 text-center me-1" tabindex="0" data-bs-toggle="popover" data-bs-placement="top" data-bs-trigger="hover focus" data-bs-content="User will be able only create the data for this module '{{ $item->name }}'">
                                                                {{ str_replace('_'.strtolower($item->name),'',$permission->name) }}
                                                                <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" fill="currentColor" class="bi bi-info-circle text-primary" viewBox="0 0 16 16">
                                                                    <path d="M8 15A7 7 0 1 1 8 1a7 7 0 0 1 0 14m0 1A8 8 0 1 0 8 0a8 8 0 0 0 0 16"/>
                                                                    <path d="m8.93 6.588-2.29.287-.082.38.45.083c.294.07.352.176.288.469l-.738 3.468c-.194.897.105 1.319.808 1.319.545 0 1.178-.252 1.465-.598l.088-.416c-.2.176-.492.246-.686.246-.275 0-.375-.193-.304-.533zM9 4.5a1 1 0 1 1-2 0 1 1 0 0 1 2 0"/>
                                                                </svg>
                                                            </span>
                                                        @elseif (str_contains($permission->name,'update'))
                                                            <span class="alert alert-info cursor-pointer py-1 px-2 text-center me-1" tabindex="0" data-bs-toggle="popover" data-bs-placement="top" data-bs-trigger="hover focus" data-bs-content="User will be able only edit and update the data for this module '{{ $item->name }}'">
                                                                {{ str_replace('_'.strtolower($item->name),'',$permission->name) }}
                                                                <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" fill="currentColor" class="bi bi-info-circle text-info" viewBox="0 0 16 16">
                                                                    <path d="M8 15A7 7 0 1 1 8 1a7 7 0 0 1 0 14m0 1A8 8 0 1 0 8 0a8 8 0 0 0 0 16"/>
                                                                    <path d="m8.93 6.588-2.29.287-.082.38.45.083c.294.07.352.176.288.469l-.738 3.468c-.194.897.105 1.319.808 1.319.545 0 1.178-.252 1.465-.598l.088-.416c-.2.176-.492.246-.686.246-.275 0-.375-.193-.304-.533zM9 4.5a1 1 0 1 1-2 0 1 1 0 0 1 2 0"/>
                                                                </svg>
                                                            </span>
                                                        @elseif (str_contains($permission->name,'delete'))
                                                            <span class="alert alert-danger cursor-pointer py-1 px-2 text-center me-1" tabindex="0" data-bs-toggle="popover" data-bs-placement="top" data-bs-trigger="hover focus" data-bs-content="User will be able only delete the data for this module '{{ $item->name }}'">
                                                                {{ str_replace('_'.strtolower($item->name),'',$permission->name) }}
                                                                <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" fill="currentColor" class="bi bi-info-circle text-danger" viewBox="0 0 16 16">
                                                                    <path d="M8 15A7 7 0 1 1 8 1a7 7 0 0 1 0 14m0 1A8 8 0 1 0 8 0a8 8 0 0 0 0 16"/>
                                                                    <path d="m8.93 6.588-2.29.287-.082.38.45.083c.294.07.352.176.288.469l-.738 3.468c-.194.897.105 1.319.808 1.319.545 0 1.178-.252 1.465-.598l.088-.416c-.2.176-.492.246-.686.246-.275 0-.375-.193-.304-.533zM9 4.5a1 1 0 1 1-2 0 1 1 0 0 1 2 0"/>
                                                                </svg>
                                                            </span>
                                                        @else
                                                            <span class="alert alert-warning cursor-pointer py-1 px-2 text-center me-1" tabindex="0" data-bs-toggle="popover" data-bs-placement="top" data-bs-trigger="hover focus" data-bs-content="User will be able only change the status the data for this module '{{ $item->name }}'">
                                                                {{ str_replace('_'.strtolower($item->name),'',$permission->name) }}
                                                                <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" fill="currentColor" class="bi bi-info-circle text-warning" viewBox="0 0 16 16">
                                                                    <path d="M8 15A7 7 0 1 1 8 1a7 7 0 0 1 0 14m0 1A8 8 0 1 0 8 0a8 8 0 0 0 0 16"/>
                                                                    <path d="m8.93 6.588-2.29.287-.082.38.45.083c.294.07.352.176.288.469l-.738 3.468c-.194.897.105 1.319.808 1.319.545 0 1.178-.252 1.465-.598l.088-.416c-.2.176-.492.246-.686.246-.275 0-.375-.193-.304-.533zM9 4.5a1 1 0 1 1-2 0 1 1 0 0 1 2 0"/>
                                                                </svg>
                                                            </span> 
                                                        @endif 
                                                        
                                                    @endforeach
                                                @endif
                                            </td>
                                           
                                            <td><small>{{ date('d M Y / h:i a',strtotime($item->created_at)) }}<br>{{ date('d M Y / h:i a',strtotime($item->updated_at)) }}</small></td>
                                            @canany(['update_permission','delete_permission','update_all','delete_all'])
                                            <td x-data="{id:null}" class="text-center">
                                                <a href="javascript:void(0);" class="dropdown dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
                                                    <svg xmlns="http://www.w3.org/2000/svg" width="35" height="35" fill="currentColor" class="bi bi-three-dots-vertical" viewBox="0 0 16 16">
                                                        <path d="M9.5 13a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0m0-5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0m0-5a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0"/>
                                                    </svg>
                                                    <ul class="dropdown-menu dropdown-menu-end dropdown-menu-arrow mt-2 z-3">
                                                        @canany(['update_permission','update_all'])
                                                        <li>
                                                            <button class="dropdown-item text-info" type="button" wire:click="edit({{ $item->id }})">
                                                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-pencil-square" viewBox="0 0 16 16">
                                                                    <path d="M15.502 1.94a.5.5 0 0 1 0 .706L14.459 3.69l-2-2L13.502.646a.5.5 0 0 1 .707 0l1.293 1.293zm-1.75 2.456-2-2L4.939 9.21a.5.5 0 0 0-.121.196l-.805 2.414a.25.25 0 0 0 .316.316l2.414-.805a.5.5 0 0 0 .196-.12l6.813-6.814z"/>
                                                                    <path fill-rule="evenodd" d="M1 13.5A1.5 1.5 0 0 0 2.5 15h11a1.5 1.5 0 0 0 1.5-1.5v-6a.5.5 0 0 0-1 0v6a.5.5 0 0 1-.5.5h-11a.5.5 0 0 1-.5-.5v-11a.5.5 0 0 1 .5-.5H9a.5.5 0 0 0 0-1H2.5A1.5 1.5 0 0 0 1 2.5z"/>
                                                                </svg>
                                                                Edit
                                                            </button>
                                                        </li>
                                                        @endcanany
                                                        @canany(['delete_permission','delete_all'])
                                                        <li>
                                                            <button class="dropdown-item text-danger" type="button" data-bs-toggle="modal" data-bs-target="#confirmModal" x-on:click="deleteId=[{{ $item->id }}]">
                                                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-trash" viewBox="0 0 16 16">
                                                                    <path d="M5.5 5.5A.5.5 0 0 1 6 6v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5m2.5 0a.5.5 0 0 1 .5.5v6a.5.5 0 0 1-1 0V6a.5.5 0 0 1 .5-.5m3 .5a.5.5 0 0 0-1 0v6a.5.5 0 0 0 1 0z"/>
                                                                    <path d="M14.5 3a1 1 0 0 1-1 1H13v9a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V4h-.5a1 1 0 0 1-1-1V2a1 1 0 0 1 1-1H6a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1h3.5a1 1 0 0 1 1 1zM4.118 4 4 4.059V13a1 1 0 0 0 1 1h6a1 1 0 0 0 1-1V4.059L11.882 4zM2.5 3h11V2h-11z"/>
                                                                </svg>
                                                                Delete
                                                            </button>
                                                        </li>
                                                        @endcanany
                                                    </ul>
                                                </a>
                                            </td>
                                            @endcanany
                                        </tr>
                                        @endforeach
                                    </tbody>
                                    @else
                                    <tfoot>
                                        <tr>
                                            <th colspan="7">No record found</th>
                                        </tr>
                                    </tfoot>
                                    @endif
                                </table>
                            </div>
                            {{$collection->onEachSide(1)->links('components.layouts.pagination')}}
                        </div>
                    </div>
                </div>
                <!-- Confirm Modal Modal -->
    @include('components.layouts.confirm-modal')
    </section>
    <!-- Toast Notification -->
    <x-toast on="response"></x-toast>
    <!-- Include the dynamic modal -->
    @include('admin.permissions.create')
    @include('admin.permissions.edit')
</div>
@script
    <script>
        $wire.on('showModal', (event) => {
            setTimeout(function () {
                const modal = new bootstrap.Modal(document.getElementById(event[0].modal));
                modal.show();
            },0);
        });
        $wire.on('hideModal', (event) => {
            setTimeout(function () {
                const modalElement = document.getElementById(event[0].modal);
                const modal = bootstrap.Modal.getInstance(modalElement);
                modal.hide();
                Livewire.dispatch(event[0].modal);
            },0);
        });
    </script>
@endscript
