<div>
    @if($editModal)
    <div class="modal fade" id="editModal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="editModalLabel" aria-hidden="true" wire:ignore.self>
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <form wire:submit="update({{ $role->id}})" accept-charset="UTF-8" enctype="multipart/form-data" novalidate>
                    <div class="modal-header">
                        <div class="modal-title fs-6">Update Role</div>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" wire:click="$dispatch('editModal')"></button>
                    </div>
                    <div class="modal-body mx-md-4">
                        <div class="mb-3">
                            <x-input-floating name="name" :messages="$errors->get('name')"/>
                        </div>
                        <div class="mb-3">
                            <x-textarea-floating name="description" :messages="$errors->get('description')" placeholder="Write role description here...." style="min-height:100px;"/>
                        </div>
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead class="table-light">
                                    <tr>
                                        <th>Modules</th>
                                        <th>Permissions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @if(count($modules)>0)
                                    @foreach($modules as $module)
                                    <tr>
                                        <td>{{ $module->name }}</td>
                                       <td>
                                        @if(count($module->permissions)>0)
                                            @foreach($module->permissions as $permission)
                                            <div class="form-check form-check-inline me-2">
                                                <x-input-floating type="checkbox" name="permissions" :messages="$errors->get('permissions')" value="{{ $permission->id }}" id="{{ $permission->id }}" label="{{ ucfirst(str_replace('_'.strtolower($module->name),'',$permission->name)) }}" />
                                            </div>
                                            @endforeach
                                            @endif
                                        </td>
                                    </tr>
                                    @endforeach
                                    @endif
                                </tbody>
                              </table>
                          </div>
                    </div>
                    <div class="modal-footer justify-content-between">
                        <button type="reset" class="btn btn-warning">Reset</button>
                        <div>
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal" wire:click="$dispatch('editModal')">Close</button>
                            <button type="submit" class="btn btn-primary"  wire:loading.attr="disabled" wire:loading.class="opacity-50">
                                <span wire:loading wire:target="update({{ $role->id}})" class="spinner-border spinner-border-sm me-2" aria-hidden="true"></span>
                                {{ __('Submit') }}
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
    @endif
</div>