<div>
    <section class="mb-3">
        <div class="row row-cols-1 row-cols-sm-2 row-cols-lg-2 g-2 g-lg-3">
            <div class="col">
                <h5 class="mb-0">General Settings <small class="fs-6">List</small></h5>
            </div>
            <div class="col">
        
            </div>
        </div>
    </section>
    <section class="content">
        <div class="row row-cols-1 row-cols-sm-2 row-cols-lg-2 g-3 g-lg-3">
            <div class="col">
                <form wire:submit="update" class="needs-validation" enctype="multipart/form-data"  accept-charset="UTF-8" novalidate>
                <div class="card mb-3 shadow-sm">
                    <div class="card-header py-3">
                        <div class="fs-6 text-body-tertiary">Update General Settings</div>
                    </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <x-input-floating name="app_name" :messages="$errors->get('app_name')"/>
                                    </div>
                                    <div class="mb-3">
                                        <x-input-floating name="url" :messages="$errors->get('url')"/>
                                    </div>
                                    <div class="mb-3">
                                        <x-input-floating type="email" name="primary_email" :messages="$errors->get('primary_email')"/>
                                    </div>
                                    <div class="mb-3">
                                        <x-input-floating type="email" name="other_email" :messages="$errors->get('other_email')"/>
                                    </div>
                                    <div class="mb-3">
                                        <div class="input-group">
                                            <x-input-floating name="primary_phone" :messages="$errors->get('primary_phone')"/>
                                            <x-input-floating name="other_phone" :messages="$errors->get('other_phone')"/>
                                        </div>
                                    </div>
                                    <div class="mb-3">
                                        <div class="input-group">
                                            <x-input-floating name="building" :messages="$errors->get('building')"/>
                                            <x-input-floating name="street" :messages="$errors->get('street')"/>
                                        </div>
                                    </div>
                                    <div class="mb-3">
                                        <div class="input-group">
                                            <x-input-floating name="city" :messages="$errors->get('city')"/>
                                            <x-input-floating name="state" :messages="$errors->get('state')"/>
                                        </div>
                                    </div>
                                    <div class="mb-3">
                                        <div class="input-group">
                                            <x-input-floating name="postal_code" :messages="$errors->get('postal_code')"/>
                                            <x-input-floating name="country" :messages="$errors->get('country')"/>
                                        </div>
                                    </div>
                                    <div class="mb-3">
                                        <x-input-floating name="address" :messages="$errors->get('address')"/>
                                    </div>
                                    <div class="mb-3">
                                        <div class="input-group">
                                            <x-input-floating name="latitude" :messages="$errors->get('latitude')"/>
                                            <x-input-floating name="longitude" :messages="$errors->get('longitude')"/>
                                        </div>
                                    </div>
                                    <div class="mb-3">
                                        <x-input-floating name="embed_map" :messages="$errors->get('embed_map')"/>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <img src="{{ asset(Request::get('settings')[2]->value) }}" class="img-thumbnail mb-2" alt="...">
                                        <x-input-floating type="file" name="site_logo" :messages="$errors->get('site_logo')"/>
                                    </div>
                                    <div class="mb-3">
                                        <img src="{{ asset(Request::get('settings')[3]->value) }}" class="img-thumbnail mb-2" alt="...">
                                        <x-input-floating type="file" name="app_logo" :messages="$errors->get('app_logo')"/>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-footer d-flex justify-content-around py-2">
                            <button type="reset" class="btn btn-warning">Reset</button>
                            <button type="submit" class="btn btn-primary" wire:loading.attr="disabled" wire:loading.class="opacity-50">
                                <span wire:loading wire:target="update" class="spinner-border spinner-border-sm me-2"></span>
                                {{ __('Submit') }}
                            </button>
                        </div>
                    </div>
                </form>
            </div>
            <div class="col">
                <div class="card mb-3 shadow-sm">
                    <div class="card-header py-3">
                        <div class="fs-6 text-body-tertiary"> Appication Development and Production Settings</div>
                    </div>
                    <div class="card-body">
                        @if(env('APP_ENV') === 'local' && env('APP_DEBUG') === TRUE || config('app.env') === 'locale' && config('app.debug') === TRUE)
                        <div class="alert alert-warning d-flex justify-content-between align-items-center p-2">
                            <span>Currently application is running in developement mode.</span> 
                            <a href="{{ route('general.settings') }}" wire:click="setProductionMode" class="btn btn-success text-nowrap" wire:loading.attr="disabled" wire:loading.class="opacity-50">
                                <span wire:loading wire:target="setProductionMode" class="spinner-border spinner-border-sm me-2"></span>
                                {{ __('Go Live') }}
                            </a>
                        </div>
                        @endif
                        
                        @if(env('APP_ENV') === 'production' && env('APP_DEBUG') === FALSE || config('app.env') === 'production' && config('app.debug') === FALSE)
                        <div class="alert alert-success d-flex justify-content-between align-items-center p-2">
                            <span>Currently application is running in production mode.</span> 
                            <button type="button" wire:click="development" class="btn btn-warning text-nowrap" wire:loading.attr="disabled" wire:loading.class="opacity-50">
                                <span wire:loading wire:target="development" class="spinner-border spinner-border-sm me-2"></span>
                                {{ __('Development') }}
                            </button>
                        </div>
                        @endif
                        <div class="alert alert-primary d-flex justify-content-between align-items-center p-2">
                            <span>Clear compiled views to make views up to date.</span> 
                            <button type="button" wire:click="clearCompiledViews" class="btn btn-primary text-nowrap" wire:loading.attr="disabled" wire:loading.class="opacity-50">
                                <span wire:loading wire:target="clearCompiledViews" class="spinner-border spinner-border-sm me-2"></span>
                                {{ __('Refresh compiled views') }}
                            </button>
                        </div>
                        <div class="alert alert-primary d-flex justify-content-between align-items-center p-2">
                            <span>You might need to refresh the config caching when you change something on production environment.</span> 
                            <button type="button" wire:click="clearConfig" class="btn btn-primary text-nowrap" wire:loading.attr="disabled" wire:loading.class="opacity-50">
                                <span wire:loading wire:target="clearConfig" class="spinner-border spinner-border-sm me-2"></span>
                                {{ __('Clear Config Cache') }}
                            </button>
                        </div>
                        <div class="alert alert-primary d-flex justify-content-between align-items-center p-2">
                            <span>Clear cache routing.</span> 
                            <button type="button" wire:click="clearRoutesCache" class="btn btn-primary text-nowrap"  wire:loading.attr="disabled" wire:loading.class="opacity-50">
                                <span wire:loading wire:target="clearRoutesCache" class="spinner-border spinner-border-sm me-2"></span>
                                {{ __('Clear cache routing.') }}
                            </button>
                        </div>
                        <div class="alert alert-primary d-flex justify-content-between align-items-center p-2">
                            <span>Clear system log files</span> 
                            <button type="button" wire:click="clearLogs" class="btn btn-primary text-nowrap" wire:loading.attr="disabled" wire:loading.class="opacity-50">
                                <span wire:loading wire:target="clearLogs" class="spinner-border spinner-border-sm me-2"></span>
                                {{ __('Clear Log') }}
                            </button>
                        </div>
                        <div class="alert alert-primary d-flex justify-content-between align-items-center p-2 mb-0">
                            <span>Link media and files accessible.</span> 
                            <button type="button" wire:click="link" class="btn btn-primary text-nowrap" wire:loading.attr="disabled" wire:loading.class="opacity-50">
                                <span wire:loading wire:target="link" class="spinner-border spinner-border-sm me-2"></span>
                                {{ __('Link Media') }}
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Toast Notification -->
    <x-toast on="response"></x-toast>
</div>

