<div>
    @if($editModal)
    <div class="modal fade" id="editModal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="editModalLabel" aria-hidden="true" wire:ignore.self>
        <div class="modal-dialog modal-xl">
            <div class="modal-content">
                <form wire:submit="update({{ $this->user->id }})" accept-charset="UTF-8" enctype="multipart/form-data" novalidate>
                    <div class="modal-header">
                        <div class="modal-title fs-6">Update User</div>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" wire:click="$dispatch('editModal')"></button>
                    </div>
                    <div class="modal-body mx-md-3">
                        <div class="row">
                            <div class="col-md-5">
                                <h6 class="mb-3 text-primary">Employee Info</h6>
                                <div class="mb-3">
                                    <x-input-floating name="name" :messages="$errors->get('name')"/>
                                </div>
                                <div class="mb-3">
                                    <x-input-floating type="email" name="email" :messages="$errors->get('email')"/>
                                </div>
                                <div class="mb-3">
                                    <x-input-floating name="phone" :messages="$errors->get('phone')"/>
                                </div>
                                <div class="mb-3">
                                    <div class="input-group align-items-center">
                                        <div class="form-check form-check-inline">
                                            <x-input-floating type="radio" name="gender" label="Male" id="Male" value="Male"/>
                                        </div>
                                        <div class="form-check form-check-inline">
                                            <x-input-floating type="radio" name="gender" label="Female" id="Female" value="Female"/>
                                        </div>
                                        <x-input-error :messages="$errors->get('gender')"/>
                                    </div>
                                </div>
                                <div class="mb-3">
                                    <x-input-floating name="date_of_birth" class="datepicker" :messages="$errors->get('date_of_birth')"/>
                                </div>
                                <div class="mb-3">
                                    <x-input-floating name="joining_date" class="datepicker" :messages="$errors->get('joining_date')"/>
                                </div>
                                <div class="mb-3">
                                    <x-input-floating model=".defer" type="file" name="image" :messages="$errors->get('image')"/>
                                </div>
                                <h6 class="mb-3 text-primary">Set Password</h6>
                                <div class="mb-3">
                                    <div class="form-check">
                                        <x-input-floating type="checkbox" name="change_password" :messages="$errors->get('change_password')" label="Change Password ? "/>
                                    </div>
                                </div>
                                <div class="mb-3">
                                    <x-input-floating type="password" name="password" :messages="$errors->get('password')"/>
                                </div>
                                <div class="mb-3">
                                    <x-input-floating type="password" name="password_confirmation" :messages="$errors->get('password_confirmation')"/>
                                </div>
                            </div>
                            <div class="col-md-7">
                                <h6 class="mb-3 text-primary">Roles and Permissions</h6>
                                <div class="mb-3">
                                    <livewire:admin.choices-component model="user_roles" :options="$roles" :selected="$user_roles" :multiple="true"/>
                                    <x-input-error :messages="$errors->get('user_roles')"/>
                                </div>
                                <div class="table-responsive">
                                    <table class="table">
                                        <thead class="table-light">
                                            <tr>
                                                <th>Module</th>
                                                <th>Permissions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @if(count($modules)>0)
                                            @foreach($modules as $module)
                                            <tr>
                                                <td>{{ $module->name }}</td>
                                               <td>
                                                @if(count($module->permissions)>0)
                                                    @foreach($module->permissions as $permission)
                                                    <div class="form-check form-check-inline me-2">
                                                        <x-input-floating type="checkbox" name="user_permissions" :messages="$errors->get('user_permissions')" value="{{ $permission->id }}" id="{{ $permission->id }}" label="{{ ucfirst(str_replace('_'.strtolower($module->name),'',$permission->name)) }}" />
                                                    </div>
                                                    @endforeach
                                                @endif
                                                </td>
                                            </tr>
                                            @endforeach
                                            @endif
                                        </tbody>
                                      </table>
                                  </div>
                            </div>
                        </div>
                      </div>
                    <div class="modal-footer justify-content-between">
                        <button type="reset" class="btn btn-warning">Reset</button>
                        <div>
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal" wire:click="$dispatch('editModal')">Close</button>
                            <button type="submit" class="btn btn-primary"  wire:loading.attr="disabled" wire:loading.class="opacity-50">
                                <span wire:loading wire:target="update({{ $this->user->id }})" class="spinner-border spinner-border-sm me-2" aria-hidden="true"></span>
                                {{ __('Submit') }}
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
    @endif
</div>