<div>
    <style>
        .glo-reservation {
            background: #fff;
        }
        .glo-reservation-thumb .img-hover.overlay {
            display: block;
        }
        .img-hover.overlay {
            position: relative;
            overflow: hidden;
        }
        .img-hover.overlay::before {
            height: 100%;
            width: 100%;
            content: "";
            background: #181b1c;
            position: absolute;
            top: 0;
            left: 0;
            opacity: 0;
            visibility: hidden;
            z-index: 1;
            transform: translate(100%, 100%);
            transition: opacity 400ms ease, visibility 400ms ease, transform 600ms ease, -webkit-transform 600ms ease;
        }
        .glo-reservation-thumb .img-hover.overlay img {
            width: 100%;
            min-height: 230px;
        }
        .img-hover img {
            -webkit-transition: all 0.4s ease-out 0s;
            -moz-transition: all 0.4s ease-out 0s;
            -ms-transition: all 0.4s ease-out 0s;
            -o-transition: all 0.4s ease-out 0s;
            transition: all 0.4s ease-out 0s;
        }
        .glo-reservation-content {
            padding: 30px 35px 28px;
        }
        .glo-reservation-info-wrapper {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            align-items: center;
            justify-content: center;
            gap: 10px;
        }
        .glo-reservation-info {
            transition: 0.5s;
        }
        .glo-reservation-info i {
            font-size: 16px;
            color: var(--clr-theme-1);
        }
        .glo-reservation-info span {
            font-size: 14px;
            margin-inline-start: 5px;
            text-transform: uppercase;
            letter-spacing: 1px;
            color: #1e2223
        }
        .glo-reservation-title {
            /* font-size: 24px; */
            margin-bottom: 15px;
        }
        .glo-reservation-content p {
            margin-bottom: 30px;
        }
        .glo-reservation-price h4 {
            font-size: 18px;
            text-transform: capitalize;
            color: #1e2223
            margin-bottom: 0;
        }
        .glo-reservation-price h4 span {
            font-size: 15px;
            margin-inline-start: 5px;
            color: #777777;
        }
    </style>
    <section class="ftco-section bg-light">
        <div class="container-xl">
            <div class="row justify-content-center">
                <div class="col-md-8 heading-section text-center mb-5 aos-init" data-aos="fade-up" data-aos-duration="1000">
                    <span class="subheading">{{ __("web.checkout our Awards & Achievements")}}</span>
                    <h2 class="mb-4">{{ __("web.Awards & Achievements")}}</h2>
                </div>
            </div>
            <section class="glo-reservation-area pt-120 pb-90">
                <div class="container">
                    <div class="row">
                        @if($awards->count()) @foreach($awards as $award)
                        <div
                            class="col-sm-12 col-md-6 col-xxl-4 col-xl-4 col-lg-4 mb-4 wow fadeInUp"
                            data-wow-duration="1s"
                            data-wow-delay=".3s"
                            style="visibility: visible; animation-duration: 1s; animation-delay: 0.3s; animation-name: fadeInUp;"
                        >
                            <div class="glo-reservation">
                                <div class="glo-reservation-thumb">
                                    <a href="room-details.html">
                                        <div class="img-hover overlay">
                                            <img src="{{asset($award->image)}}" alt="Image not found" />
                                        </div>
                                    </a>
                                </div>
                                <div class="glo-reservation-content">
                                    <h3 class="glo-reservation-title"><a href="room-details.html">{{$award->translation()->name}}</a></h3>
                                    <p class="mb-15">{{$award->translation()->review}}</p>
                                </div>
                            </div>
                        </div>
                        @endforeach @else
                        <div
                            class="col-sm-12 col-md-12 col-xxl-12 col-xl-12 col-lg-12 mb-4 wow text-center fadeInUp"
                            data-wow-duration="1s"
                            data-wow-delay=".3s"
                            style="visibility: visible; animation-duration: 1s; animation-delay: 0.3s; animation-name: fadeInUp;"
                        >
                            <img src="{{asset('storage/defaults/coming-soon.png')}}" alt="" />
                        </div>
                        @endif
                    </div>
                </div>
            </section>
        </div>
    </section>
</div>
