<div>
    <section class="ftco-section">
        <div class="container-xl">
            <div class="row justify-content-center">
                <div class="col-md-8 heading-section text-center mb-5 aos-init" data-aos="fade-up" data-aos-duration="1000">
                    <span class="subheading">{{ __("web.checkout our amazing offers") }}</span>
                    <h2 class="mb-4">{{ __("web.Offer and Promotions") }}</h2>
                </div>
            </div>
            <section class="glo-reservation-area pt-120 pb-90">
                <div class="container">
                    <div class="row row-cols-1 row-cols-lg-3 g-3 g-lg-4 justify-content-center">
                        @if($offers->count()) @foreach($offers as $offer)
                        <div class="col wow fadeInUp" data-wow-duration="1s" data-wow-delay=".3s" style="visibility: visible; animation-duration: 1s; animation-delay: 0.3s; animation-name: fadeInUp;">
                            <div class="glo-reservation">
                                <div class="glo-reservation-thumb">
                                    <a href="{{ route('offer-detail',$offer->slug) }}">
                                        <div class="img-hover overlay">
                                            <img src="{{asset($offer->image)}}" alt="Image not found" />
                                        </div>
                                    </a>
                                </div>
                                <div class="glo-reservation-content">
                                    <div class="d-flex justify-content-between align-items-center mb-3">
                                        <div class="glo-reservation-info">
                                            <i class="bi bi-check2"></i>
                                            <span>{{ __("web.Valid Untill") }}</span>
                                        </div>
                                        <div class="glo-reservation-info">
                                            <i class="bi bi-clock"></i>
                                            <span>{{date('d M y',strtotime($offer->start_from))}} - {{date('d M y',strtotime($offer->valid_untill))}}</span>
                                        </div>
                                    </div>
                                    <h3 class="glo-reservation-title"><a href="{{ route('offer-detail',$offer->slug) }}">{{$offer->translation()->title}}</a></h3>
                                    <p class="mb-15">{{$offer->translation()->short_description}}</p>
                                    <div class="glo-reservation-price d-flex justify-content-between align-items-center">
                                        <div class="glo-reservation-btn">
                                            <a href="https://www.booking.com/hotel/qa/imperial-suites.html" class="btn btn-primary text-nowrap py-3 px-4" target="_blank">{{ __("web.Book Now") }}</a>
                                        </div>
                                        <h4>{{ __("web.from") }} {{ __("web.QAR") }} {{$offer->price}}<span> / {{ __("web.night") }}</span></h4>
                                    </div>
                                </div>
                            </div>
                        </div>
                        @endforeach @else
                        <div
                            class="col-sm-12 col-md-12 col-xxl-12 col-xl-12 col-lg-12 mb-4 wow text-center fadeInUp"
                            data-wow-duration="1s"
                            data-wow-delay=".3s"
                            style="visibility: visible; animation-duration: 1s; animation-delay: 0.3s; animation-name: fadeInUp;">
                            <img src="{{asset('storage/defaults/coming-soon.png')}}" alt="" />
                        </div>
                        @endif
                    </div>
                </div>
            </section>
        </div>
    </section>
</div>
