
@section('pageTitle', $pageTitle)
@section('metaDescription', $metaDescription)
<div>
<section class="hero-wrap">
    <div>
        <video autoplay muted loop style="width: 100%; height: auto;">
            <source src="{{ asset('storage/defaults/video.mp4') }}?v=1" type="video/mp4" />
        </video>
    </div>
    <div class="container video-overlay">
        <div class="row no-gutters slider-text align-items-center justify-content-center" style="height: auto; min-height: auto;">
            <div class="col-md-9 pt-5 text-center">
                <span class="subheading">{{ __("web.Enjoy Your Wonderful Holidays With A Great Luxury Experience!") }}</span>
                <h1 class="mb-4">{{ __("web.Most Relaxing Place") }}</h1>
            </div>
        </div>
    </div>
</section>
<section class="ftco-section ftco-about-section">
    <div class="container-xl">
        <div class="row justify-content-center">
            <div class="col-md-8 heading-section text-center mb-5 aos-init" data-aos="fade-up" data-aos-duration="1000">
                <h2 class="mb-4">{{ __("web.Welcome To Imperial Suites") }}</h2>
            </div>
        </div>
        <div class="row g-xl-5">
            <div class="col-md-6 heading-section d-flex align-items-center aos-init" data-aos="fade-up" data-aos-delay="200" data-aos-duration="1000">
                <div class="mt-5 mt-md-0">
                    <p class="fs-1 mb-1">{{ __("web.A NEW VISION OF LUXURY") }}</p>
                    <p class="mb-3">
                        {{ __("web.Whether you are visiting Doha for business or leisure our address is your destination, you’re guaranteed unforgettable experience of comfort, luxury and enjoyable stay. We are located in the heart of Doha") }}
                    </p>
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="ftco-footer-widget mb-4">
                                <ul class="list-unstyled">
                                    <li class="mb-2">
                                        <a href="#"><span class="fa fa-plane {{ session('direction') == 'ltr' ? 'me-2' : 'ms-2' }}"></span>{{ __("web.10 minutes from Hamad International Airport") }}</a>
                                    </li>
                                    <li class="mb-2">
                                        <a href="#"><span class="fa fa-plane {{ session('direction') == 'ltr' ? 'me-2' : 'ms-2' }}"></span>{{ __("web.7 minutes from Doha Old Port") }}</a>
                                    </li>
                                    <li class="mb-2">
                                        <a href="#"><span class="fa fa-building {{ session('direction') == 'ltr' ? 'me-2' : 'ms-2' }}"></span>{{ __("web.5 minutes from Souq Waqif") }}</a>
                                    </li>
                                    <li class="mb-2">
                                        <a href="#"><span class="fa fa-institution {{ session('direction') == 'ltr' ? 'me-2' : 'ms-2' }}"></span>{{ __("web.5 minutes from Qatar Museums") }}</a>
                                    </li>
                                    <li class="mb-2">
                                        <a href="#"><span class="fa fa-umbrella {{ session('direction') == 'ltr' ? 'me-2' : 'ms-2' }}"></span>{{ __("web.10 minutes from Corniche") }}</a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <p><a href="https://www.booking.com/hotel/qa/imperial-suites.html" class="btn btn-primary py-md-4 py-3 px-md-5 px-4" target="_blank">{{ __("web.Book Your Room Now") }}</a></p>
                </div>
            </div>
            <div class="col-md-6 aos-init" data-aos="fade-up" data-aos-delay="100" data-aos-duration="1000">
                <div class="row row-cols-1 row-cols-sm-2 row-cols-lg-2 g-2 g-lg-3">
                    <div class="col">
                        <a href="{{route('rooms')}}" wire:navigate>
                            <div class="f-services d-md-flex flex-md-column-reverse">
                                <div class="img w-100 mb-md-4" style="background-image: url({{asset('storage/rooms/room.png')}});"></div>
                                <div class="text w-100 p-4 text-center mb-md-4">
                                    <div class="icon"><span class="flaticon-pillow"></span></div>
                                    <h3>{{ __("web.ROOMS & SUITES") }}</h3>
                                    <p>{{ __("web.Discover Blissful Comfort: Elevate Your Stay with Our Signature Suites and Unmatched Hospitality.") }}</p>
                                </div>
                            </div>
                        </a>
                    </div>
                    <div class="col">
                        <a href="{{route('offers')}}" wire:navigate>
                            <div class="f-services">
                                <div class="img w-100 mb-md-4" style="background-image: url({{asset('storage/offers/hotel.jpg')}});"></div>
                                <div class="text w-100 p-4 text-center">
                                    <div class="icon"><span class="flaticon-special"></span></div>
                                    <h3>{{ __("web.Special Offers") }}</h3>
                                    <p>{{ __("web.Budget hotel room rates Take it from us. You`re in good hands. See our offers") }}</p>
                                </div>
                            </div>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<section class="ftco-section">
    <div class="container-xl">
        <div class="row justify-content-center">
            <div class="col-md-8 heading-section text-center mb-5 aos-init" data-aos="fade-up" data-aos-duration="1000">
                <span class="subheading">{{ __("web.Imperail Services") }}</span>
                <h2 class="mb-4">{{ __("web.Explore Our Hotel Services") }}</h2>
            </div>
        </div>
        <div class="row row-cols-2 row-cols-lg-6 g-2 g-lg-3 justify-content-center mb-5">
            @if($services->count()) @foreach ($services as $service)
            <div class="col text-center d-flex align-items-stretch aos-init" data-aos="fade-up" data-aos-delay="100" data-aos-duration="1000">
                <a href="#" class="services">
                    <div class="icon">
                        <img src="{{ asset($service->image) }}" class="img-fluid" alt="..." />
                    </div>
                    <div class="text">
                        <h2>{{ $service->translation()->name }}</h2>
                    </div>
                </a>
            </div>
            @endforeach @endif
        </div>
        <div class="row justify-content-center mb-5">
            <div class="col-md-12 text-center">
                <p class="mb-0"><a href="{{ route('services') }}" wire:navigate class="btn btn-primary py-md-4 py-3 px-md-5 px-4">{{ __("web.View More") }}</a></p>
            </div>
        </div>
    </div>
</section>
<section class="ftco-intro ftco-no-pt ftco-no-pb img" style="background-image: url(https://preview.colorlib.com/theme/unwind/images/bg_1.jpg.webp);">
    <div class="overlay"></div>
    <div class="container-xl py-5">
        <div class="row justify-content-center">
            <div class="col-lg-10 col-xl-8">
                <div class="row aos-init" data-aos="fade-up" data-aos-duration="1000">
                    <div class="col-md-8 my-auto d-flex align-items-center">
                        <div>
                            <span class="subheading">{{ __("web.Find Best Hotel For Living") }}</span>
                            <h1 class="mb-md-0 mb-4">{{ __("web.Find the Best Hotel in Your Next Vacation") }}</h1>
                        </div>
                    </div>
                    <div class="col-md-4 my-auto text-center">
                        <p class="mb-0"><a href="https://www.booking.com/hotel/qa/imperial-suites.html" target="_blank" class="btn btn-primary py-md-4 py-3 px-md-5 px-4 w-100">{{ __("web.Book Now") }}</a></p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<section class="ftco-section">
    <div class="container-xl">
        <div class="row justify-content-center">
            <div class="col-md-8 heading-section text-center mb-5 aos-init" data-aos="fade-up" data-aos-duration="1000">
                <span class="subheading">{{ __("web.Imperial Rooms") }}</span>
                <h2 class="mb-4">{{ __("web.Rooms & Suites") }}</h2>
            </div>
        </div>
        <div class="row row-cols-1 row-cols-lg-3 g-2 g-lg-3 justify-content-center">
            @if ($rooms->count()) @foreach($rooms as $room)
            <div class="col d-flex align-items-stretch aos-init" data-aos="flip-left" data-aos-delay="100" data-aos-duration="1000">
                <div class="room-wrap {{ $loop->iteration % 2 == 0 ? 'd-md-flex flex-md-column-reverse' :'' }}">
                    @if ($room->photos->count())
                    <div id="carouselExampleAutoplaying-{{ $loop->iteration }}" class="carousel slide" data-bs-ride="carousel">
                        <div class="carousel-inner">
                            @foreach($room->photos as $key => $photo)
                            <div class="carousel-item @if($key == 0) active @endif">
                                <a href="{{ URL::to('room/'.$room->slug) }}" aria-label="{{ $room->translation()->name }}" wire:navigate>
                                    <img src="{{ asset( $photo->photo) }}" class="d-block w-100" alt="" />
                                </a>
                            </div>
                            @endforeach
                        </div>
                    </div>
                    @endif
                    <div class="text p-5 pb-4 text-center">
                        <p class="fs-3 mb-0 text-uppercase"><a href="{{ URL::to('room/'.$room->slug) }}">{{ $room->translation()->name }}</a></p>
                        <p>{{ $room->translation()->short_description }}</p>
                        <p class="mt-5 text-uppercase price">{{ __("web.Starting From") }}</p>
                        <p class="d-flex mb-0 justify-content-between align-items-center">
                            <span class="price text-uppercase">{{ $room->price }} <small>/ {{ __("web.night") }}</small></span>
                            <a href="https://www.booking.com/hotel/qa/imperial-suites.html" target="_blank" class="btn-custom">{{ __("web.Book Now") }}</a>
                        </p>
                    </div>
                </div>
            </div>
            @endforeach @endif
        </div>
    </div>
</section>
<section class="img vid-section" style="background-image: url(storage/defaults/bg-tour.jpg);">
    <div class="overlay"></div>
    <div class="container-xl">
        <div class="row justify-content-center">
            <div class="col-md-10 vid-height d-flex align-items-center justify-content-center text-center">
                <div class="video-wrap aos-init" data-aos="fade-up">
                    <span class="subheading">{{ __("web.Watch our luxurious hotel") }}</span>
                    <h3>{{ __("web.Take A Tour") }}</h3>
                    <a href="{{ asset('storage/defaults/video.mp4') }}" class="video-icon glightbox d-flex align-items-center justify-content-center" aria-label="Play Video">
                        <span class="ms-2 ion-ios-play"></span>
                    </a>
                </div>
            </div>
        </div>
    </div>
</section>
<section class="ftco-section testimony-section position-relative">
    <div class="container-xl">
        <div class="row justify-content-center pb-4">
            <div class="col-md-7 text-center heading-section aos-init" data-aos="fade-up" data-aos-duration="1000">
                <span class="subheading">{{ __("web.Testimonial") }}</span>
                <h2 class="mb-3">{{ __("web.Happy Guests") }}</h2>
            </div>
        </div>
        @if($testimonials->count())
        <!-- Slider main container -->
        <div class="swiper">
            <!-- Additional required wrapper -->
            <div class="swiper-wrapper ">
                <!-- Slides -->
                @foreach($testimonials as $testimonial)
                <div class="swiper-slide">
                    <div class="testimony-wrap">
                        <div class="text">
                            <div class="d-flex align-items-center mb-4">
                                <div class="user-img" style="background-image: url({{asset('storage/defaults/testimonial-user.jpg')}})">
                                    <div class="icon d-flex align-items-center justify-content-center"><span class="fa fa-quote-left"></span></div>
                                </div>
                                <div class="{{ session('direction') == 'ltr' ? 'ps-2' : 'pe-2' }} tx">
                                    <p class="name">{{$testimonial->translation()->name }}</p>
                                    <small>{{ __("web.wrote a review") }} {{ date('d M Y',strtotime($testimonial->updated_at)) }}</small>
                                </div>
                            </div>
                            <p class="mb-4 msg">{{ $testimonial->translation()->review }}</p>
                        </div>
                    </div>
                </div>
                @endforeach
            </div>
            <!-- If we need pagination -->
            <div class="swiper-pagination"></div>
        </div>
        @endif
    </div>
</section>
<section class="ftco-gallery">
    <div class="container-fluid">
        <div class="row justify-content-center">
            <div class="col-md-8 heading-section text-center mb-5 aos-init" data-aos="fade-up" data-aos-duration="1000">
                <span class="subheading">{{ __("web.Places to visit") }}</span>
                <h2 class="mb-4">{{ __("web.Nearby Places to visit") }}</h2>
            </div>
        </div>
        <div class="row row-cols-1 row-cols-sm-2 row-cols-md-3 row-cols-lg-4 row-cols-xl-5 g-3 g-lg-3">
            <div class="col aos-init" data-aos="fade-up" data-aos-delay="100" data-aos-duration="1000">
                <a href="{{asset('storage/places/1.jpg')}}" class="gallery-wrap img d-flex align-items-center justify-content-center glightbox" style="background-image: url({{asset('storage/places/1.jpg')}});">
                    <div class="d-flex align-items-center justify-content-center" style="color: #fff; font-size: 20px;">{{ __("web.National Museum of Qatar") }}</div>
                </a>
            </div>

            <div class="col aos-init" data-aos="fade-up" data-aos-delay="100" data-aos-duration="1000">
                <a href="{{asset('storage/places/2.jpg')}}" class="gallery-wrap img d-flex align-items-center justify-content-center glightbox" style="background-image: url({{asset('storage/places/2.jpg')}});">
                    <div class="d-flex align-items-center justify-content-center" style="color: #fff; font-size: 20px;">{{ __("web.Souq Waqif") }}</div>
                </a>
            </div>
            <div class="col aos-init" data-aos="fade-up" data-aos-delay="100" data-aos-duration="1000">
                <a href="{{asset('storage/places/10.jpg')}}" class="gallery-wrap img d-flex align-items-center justify-content-center glightbox" style="background-image: url({{asset('storage/places/10.jpg')}});">
                    <div class="d-flex align-items-center justify-content-center" style="color: #fff; font-size: 20px;">{{ __("web.Doha Corniche Boats Ride") }}</div>
                </a>
            </div>
            <div class="col aos-init" data-aos="fade-up" data-aos-delay="100" data-aos-duration="1000">
                <a href="{{asset('storage/places/8.jpg')}}" class="gallery-wrap img d-flex align-items-center justify-content-center glightbox" style="background-image: url({{asset('storage/places/8.jpg')}});">
                    <div class="d-flex align-items-center justify-content-center" style="color: #fff; font-size: 20px;">{{ __("web.Msheireb Downtown Doha") }}</div>
                </a>
            </div>
            <div class="col aos-init" data-aos="fade-up" data-aos-delay="100" data-aos-duration="1000">
                <a href="{{asset('storage/places/3.jpg')}}" class="gallery-wrap img d-flex align-items-center justify-content-center glightbox" style="background-image: url({{asset('storage/places/3.jpg')}});">
                    <div class="d-flex align-items-center justify-content-center" style="color: #fff; font-size: 20px;">{{ __("web.Museum Of Islamic Art") }}</div>
                </a>
            </div>
        </div>
        <div class="row justify-content-center my-5">
            <div class="col-md-12 text-center">
                <p class="mb-0"><a href="{{ route('places') }}" wire:navigate class="btn btn-primary text-nowrap py-md-4 py-3 px-md-5 px-4">{{ __("web.View More") }}</a></p>
            </div>
        </div>
    </div>
</section>
</div>
