<?php

use Illuminate\Support\Facades\Route;
use App\Livewire\Auth;
use App\Livewire\Admin;
use App\Livewire\Web;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/
Route::get('/', Web\WelcomeComponent::class)->name('/');
Route::get('/about', Web\AboutComponent::class)->name('about');
Route::get('/rooms', Web\RoomComponent::class)->name('rooms');
Route::get('/room/{slug}', Web\RoomDetailComponent::class)->name('room-detail');
Route::get('/services', Web\ServiceComponent::class)->name('services');
Route::get('/dining', Web\DiningComponent::class)->name('dining');
Route::get('/facilities', Web\FacilityComponent::class)->name('facilities');
Route::get('/offers', Web\OfferComponent::class)->name('offers');
Route::get('/offer/{slug}', Web\OfferDetailComponent::class)->name('offer-detail');
Route::get('/awards', Web\AwardComponent::class)->name('awards');
Route::get('/places', Web\PlaceComponent::class)->name('places');
Route::get('/contact', Web\ContactComponent::class)->name('contact');

Route::get('/sitemap.xml', [App\Http\Controllers\Web\IndexController::class, 'sitemap']);





Route::middleware(['guest'])->group(function () {
    Route::get('/login', Auth\LoginComponent::class)->name('login');
    Route::get('/forgot-password', Auth\ForgotPasswordComponent::class)->name('password.request');
    Route::get('/reset-password/{token}/{email}', Auth\ResetPasswordComponent::class)->name('password.reset');
    // Email Verification Routes...
    // Route::get('email/verify', [Auth\VerificationController::class, 'show'])->middleware('auth')->name('verification.notice');
    // Route::get('email/verify/{id}/{hash}', [Auth\VerificationController::class, 'verify'])->middleware(['auth', 'signed'])->name('verification.verify');
    // Route::post('email/resend', [Auth\VerificationController::class, 'resend'])->middleware(['auth', 'throttle:5,1'])->name('verification.resend');
});
Route::get('/two-factor-verify', Auth\Login2FAComponent::class)->name('two-factor.verify')->middleware('auth');

Route::middleware(['auth','2fa.verified'])->group(function () {

    Route::get('/dashboard', Admin\HomeComponent::class)->name('dashboard');

    Route::get('/room', Admin\RoomComponent::class)->name('room');
    Route::get('/room-facility', Admin\RoomFacilityComponent::class)->name('room.facility');
    Route::get('/room-service', Admin\RoomServiceComponent::class)->name('room.service');
    Route::get('/room-privilege', Admin\RoomPrivilegeComponent::class)->name('room.privilege');

    Route::get('/award', Admin\AwardComponent::class)->name('award');
    Route::get('/offer', Admin\OfferComponent::class)->name('offer');
    Route::get('/place', Admin\PlaceComponent::class)->name('place');
    Route::get('/service', Admin\ServiceComponent::class)->name('service');
    Route::get('/feedback', Admin\FeedbackComponent::class)->name('feedback');
    Route::get('/gallery', Admin\GalleryComponent::class)->name('gallery');
    Route::get('/testimonial', Admin\TestimonialComponent::class)->name('testimonial');

    Route::get('/permission', Admin\PermissionComponent::class)->name('permission');

    Route::get('/role', Admin\RoleComponent::class)->name('role');

    Route::get('/user', Admin\UserComponent::class)->name('user');
    
    Route::get('/user-account', Admin\UserAccountComponent::class)->name('user.account');
    
    // Route::resource('/notification', Admin\NotificationController::class);
	// Route::post('/notification-status/{id}', [Admin\NotificationController::class,'status'])->name('notification.status');
	Route::get('readAll', [Admin\NotificationController::class,'readAll'])->name('readAll');
	Route::get('markAsRead/{id}', [Admin\NotificationController::class,'markAsRead'])->name('markAsRead');
	Route::get('load-more/{skip?}', [Admin\NotificationController::class,'loadMore'])->name('load.more');

    Route::get('/backup', Admin\BackupComponent::class)->name('backup');
    
    Route::get('/activity-log', Admin\ActivityLogComponent::class)->name('activity.log');
    
    Route::get('/login-history', Admin\LoginHistoryComponent::class)->name('login.history');
    Route::get('login-history-export/{format}/{ids?}', [Admin\LoginHistoryController::class,'export'])->name('login-history.export');

    Route::get('/general-settings', Admin\GeneralSettingsComponent::class)->name('general.settings');
    Route::get('/social-settings', Admin\SocialSettingsComponent::class)->name('social.settings');
    Route::get('/alert-settings', Admin\AlertSettingsComponent::class)->name('alert.settings');
    Route::get('/language-settings', Admin\LanguageSettingsComponent::class)->name('language.settings');
    Route::get('set-production-mode',[\App\Http\Controllers\Controller::class,'setProductionMode'])->name('set.production.mode');

    Route::get('/page', Admin\PageComponent::class)->name('page');

    Route::post('/logout', Auth\LoginComponent::class)->name('logout');
});